<?php

namespace Drupal\lce\Controller;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of linked content entities.
 */
class LinkedContentEntityListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Name');
    $header['id'] = $this->t('Machine name');
    $header['content'] = $this->t('Content');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\Core\Entity\EntityInterface $content_entity */
    $content_entity = $this->storage->getContentEntityByEntity($entity);
    $path = '-';

    if ($content_entity) {
      if ($content_entity->hasLinkTemplate('edit-form')) {
        $path = $content_entity->toLink();
      }
      else {
        $path = $content_entity->label();
      }
    }

    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['content'] = $path;

    return $row + parent::buildRow($entity);
  }

}
