<?php

namespace Drupal\lce\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\lce\LinkedContentEntityInterface;

/**
 * Defines the Linked Content Entity.
 *
 * @ConfigEntityType(
 *   id = "linked_content_entity",
 *   label = @Translation("Linked Content Entity"),
 *   handlers = {
 *     "storage" = "Drupal\lce\LinkedContentEntityStorage",
 *     "list_builder" = "Drupal\lce\Controller\LinkedContentEntityListBuilder",
 *     "form" = {
 *       "add" = "Drupal\lce\Form\LinkedContentEntityForm",
 *       "edit" = "Drupal\lce\Form\LinkedContentEntityForm",
 *       "delete" = "Drupal\lce\Form\LinkedContentEntityDeleteForm"
 *     }
 *   },
 *   admin_permission = "administer linked content entity",
 *   config_prefix = "content_entity",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/content/linked_content_entity/{linked_content_entity}/edit",
 *     "delete-form" = "/admin/config/content/linked_content_entity/{linked_content_entity}/delete"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "content_entity_id",
 *     "content_entity_type"
 *   }
 * )
 */
class LinkedContentEntity extends ConfigEntityBase implements LinkedContentEntityInterface {

  /**
   * The ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The label.
   *
   * @var string
   */
  protected $label;

  /**
   * Content entity id.
   *
   * @var string
   */
  protected $content_entity_id;

  /**
   * Content entity type.
   *
   * @var string
   */
  protected $content_entity_type;

  /**
   * {@inheritdoc}
   */
  public function getContentEntityId() {
    return $this->content_entity_id;
  }

  /**
   * {@inheritdoc}
   */
  public function setContentEntityId($id) {
    $this->content_entity_id = $id;

    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getContentEntityType() {
    return $this->content_entity_type;
  }

  /**
   * {@inheritdoc}
   */
  public function setContentEntityType($type) {
    $this->content_entity_type = $type;

    return $this;
  }

}
