<?php

namespace Drupal\lce;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a ParagraphsType entity.
 */
interface LinkedContentEntityInterface extends ConfigEntityInterface {

  /**
   * Get content entity id.
   *
   * @return string
   *   The content entity id.
   */
  public function getContentEntityId();

  /**
   * Set content entity id.
   *
   * @param string $id
   *   The content entity id.
   *
   * @return $this
   */
  public function setContentEntityId($id);

  /**
   * Get content entity type.
   *
   * @return mixed
   *   The content entity type or NULL when not exists.
   */
  public function getContentEntityType();

  /**
   * Set content entity type.
   *
   * @param string $type
   *   The entity type.
   *
   * @return $this
   */
  public function setContentEntityType($type);

}
