# Changelog

All notable changes to the LC Lightbox module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0-beta1] - 2025-08-04

### Added
- **Complete LC Lightbox integration** with Drupal field formatters
- **Gallery navigation** with thumbnails, arrows, and counter display
- **Auto-start configuration** - choose between click activation or automatic page load
- **Dynamic profile system** with 60+ configurable options
- **Three default profiles**:
  - **Default Profile**: Balanced settings with light theme
  - **Gallery Profile**: Enhanced features with dark theme and thumbnails
  - **Minimal Profile**: Clean, simple interface for basic use
- **Field formatter** for easy integration with image fields
- **Profile management interface** at `/admin/config/media/lc-lightbox-profile`
- **Comprehensive configuration options**:
  - Core behavior (gallery mode, modal, deeplink)
  - Visual & layout (skins, positioning, effects)
  - Sizing & dimensions (max width/height, padding, borders)
  - Animation & timing (open/close, fading, slideshow)
  - Slideshow options (autoplay, intervals, progress bar)
  - Thumbnail navigation (sizing, icons, positioning)
  - Fullscreen support (behavior, browser mode)
  - Content display (titles, descriptions, authors)
  - Social sharing and interaction options
- **Responsive design** with mobile-friendly touch/swipe navigation
- **Configuration schema** with full validation
- **JavaScript integration** with proper LC Lightbox API usage
- **Library management** with external file support

### Technical Implementation
- **Entity system** for profile management with full CRUD operations
- **Form API integration** with organized fieldsets and validation
- **JavaScript behaviors** with proper Drupal integration
- **Library definitions** with correct external file handling
- **Configuration management** with install/update hooks
- **Field formatter plugin** with settings form and summary

### Fixed
- **Library loading issues** with proper external file configuration
- **Gallery initialization** using correct LC Lightbox API
- **Navigation display** with proper HTML structure and attributes
- **Profile configuration passing** via drupalSettings to JavaScript
- **Border and styling** control through profile settings

### Developer Features
- **Extensible architecture** for custom profiles and configurations
- **Proper Drupal coding standards** compliance
- **Comprehensive documentation** in code and README
- **Debug logging** for troubleshooting (removable for production)

## [Unreleased]

### Planned for Future Releases
- **Video support** for mixed content galleries
- **Additional field types** support beyond images
- **Performance optimizations** and caching improvements
- **Additional skins** and themes
- **Import/export** functionality for profiles
- **Automated testing** suite
- **Multi-language** support improvements

---

## Release Notes

### Beta Release Status
This beta release is **feature-complete** for the core image gallery functionality. The module has been thoroughly tested and is ready for production use on non-critical sites. 

**What's Stable:**
- ✅ Image field formatter integration
- ✅ Gallery navigation and thumbnails
- ✅ Profile management system
- ✅ All 60+ configuration options
- ✅ Auto-start functionality
- ✅ Responsive design

**Feedback Welcome:**
- Edge cases with different Drupal configurations
- Performance with large image galleries
- User experience feedback on admin interface
- Additional feature requests

### Upgrade Path
This is the initial beta release. Future releases will maintain backward compatibility for:
- Profile configurations
- Field formatter settings
- JavaScript API

### Known Issues
- None currently identified
- Please report issues on the project page

### Credits
- **LC Lightbox Library**: [LCweb](https://lcweb.it/lc-lightbox-jquery-plugin/)
- **Drupal Integration**: LC Lightbox module development team
- **Testing**: Community beta testers
