# LC Lightbox for Drupal

**Version: 1.0.0-beta1**

LC Lightbox integration for Drupal - A modern jQuery lightbox focused on contents with full responsive design and extensive customization options.

> **Beta Release**: This module is feature-complete and ready for testing. Please report any issues on the project page.

## Features

- **Modern responsive lightbox** for images and mixed content
- **Gallery navigation** with thumbnails, arrows, and counter
- **Auto-start option** - activate on page load or image click
- **Multiple profiles** - Default, Gallery, and Minimal presets
- **60+ configuration options** for complete customization
- **Multiple layout options** (text over/under images, side layouts)
- **Fullscreen mode** support with browser fullscreen
- **Touch gestures** and swipe navigation for mobile
- **Social sharing** capabilities with multiple platforms
- **Multiple skins** (light, dark, minimal)
- **Integration** with Drupal's image style system
- **Field formatter** for easy content type integration

## Installation

### Requirements

- Drupal 10 or 11
- PHP 8.1 or higher

### Installation

**Step 1: Install the module**

```bash
composer require drupal/lcl
```

**Step 2: Enable the module (auto-downloads library)**

```bash
drush en lcl -y
```

The module will automatically attempt to download the LC Lightbox library during installation.

**Alternative: Manual library download**

If automatic download fails, use the Drush command:
```bash
drush lcl:download-library
```

**Verify Installation:**
Check `/admin/reports/status` to confirm the LC Lightbox library is properly detected.

## Usage

### Field Formatter

1. Go to any content type's "Manage display" page (e.g., `/admin/structure/types/manage/article/display`)
2. For image fields, select "LC Lightbox" as the formatter
3. Configure the formatter settings:
   - **LC Lightbox Profile**: Choose Default, Gallery, or Minimal
   - **Lightbox Activation**: On image click (default) or automatically on page load
   - **Image Style**: Optional image style for lightbox display

### Quick Test
1. Create content with multiple images
2. View the content page
3. Click any image to open the lightbox with full navigation

### Creating Profiles

1. Go to `/admin/config/media/lc-lightbox-profile`
2. Create new profiles with different settings for various use cases
3. Configure options like layout, animations, thumbnails, and more

## Status Reporting

The module includes status reporting that checks:
- LC Lightbox library installation
- Library file integrity
- Proper file permissions

Check `/admin/reports/status` for any issues.

## License

GPL-2.0-or-later
