<?php

declare(strict_types=1);

namespace Drupal\lcl\Commands;

use Drush\Commands\DrushCommands;

/**
 * Drush commands for LC Lightbox module.
 */
class LclCommands extends DrushCommands {

  /**
   * Download LC Lightbox library.
   *
   * @command lcl:download-library
   * @aliases lcl-dl
   * @usage lcl:download-library
   *   Download the LC Lightbox library to web/libraries/lc-lightbox-lite
   */
  public function downloadLibrary() {
    module_load_include('install', 'lcl');

    if (_lcl_download_library()) {
      $this->output()->writeln('<info>LC Lightbox library downloaded successfully!</info>');
    } else {
      $this->output()->writeln('<error>Failed to download LC Lightbox library. Please check the error messages above.</error>');
      return 1;
    }
  }

}
