<?php

declare(strict_types=1);

namespace Drupal\lcl\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\lcl\LcLightboxProfileInterface;

/**
 * Defines the lc lightbox profiles entity type.
 *
 * @ConfigEntityType(
 *   id = "lc_lightbox_profile",
 *   label = @Translation("LC Lightbox Profiles"),
 *   label_collection = @Translation("LC Lightbox Profiles"),
 *   label_singular = @Translation("lc lightbox profiles"),
 *   label_plural = @Translation("lc lightbox profiles"),
 *   label_count = @PluralTranslation(
 *     singular = "@count lc lightbox profiles",
 *     plural = "@count lc lightbox profiles",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\lcl\LcLightboxProfileListBuilder",
 *     "form" = {
 *       "add" = "Drupal\lcl\Form\LcLightboxProfileForm",
 *       "edit" = "Drupal\lcl\Form\LcLightboxProfileForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "lc_lightbox_profile",
 *   admin_permission = "administer lc_lightbox_profile",
 *   links = {
 *     "collection" = "/admin/structure/lc-lightbox-profile",
 *     "add-form" = "/admin/structure/lc-lightbox-profile/add",
 *     "edit-form" = "/admin/structure/lc-lightbox-profile/{lc_lightbox_profile}",
 *     "delete-form" = "/admin/structure/lc-lightbox-profile/{lc_lightbox_profile}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "gallery",
 *     "gallery_hook",
 *     "live_elements",
 *     "preload_all",
 *     "global_type",
 *     "deeplink",
 *     "img_zoom",
 *     "comments",
 *     "src_attr",
 *     "title_attr",
 *     "txt_attr",
 *     "author_attr",
 *     "author_by_txt",
 *     "slideshow",
 *     "open_close_time",
 *     "ol_time_diff",
 *     "fading_time",
 *     "animation_time",
 *     "slideshow_time",
 *     "autoplay",
 *     "counter",
 *     "progressbar",
 *     "carousel",
 *     "max_width",
 *     "max_height",
 *     "wrap_padding",
 *     "ol_opacity",
 *     "ol_color",
 *     "ol_pattern",
 *     "border_w",
 *     "border_col",
 *     "padding",
 *     "radius",
 *     "shadow",
 *     "remove_scrollbar",
 *     "wrap_class",
 *     "skin",
 *     "data_position",
 *     "cmd_position",
 *     "ins_close_pos",
 *     "nav_btn_pos",
 *     "txt_hidden",
 *     "show_title",
 *     "show_descr",
 *     "show_author",
 *     "thumbs_nav",
 *     "tn_icons",
 *     "tn_hidden",
 *     "thumbs_w",
 *     "thumbs_h",
 *     "thumb_attr",
 *     "thumbs_maker_url",
 *     "fullscreen",
 *     "fs_img_behavior",
 *     "fs_only",
 *     "browser_fs_mode",
 *     "socials",
 *     "fb_direct_share",
 *     "txt_toggle_cmd",
 *     "download",
 *     "autoplay_videos",
 *     "touchswipe",
 *     "mousewheel",
 *     "modal",
 *     "rclick_prevent",
 *     "opening_effect",
 *   },
 * )
 */
final class LcLightboxProfile extends ConfigEntityBase implements LcLightboxProfileInterface {

  /**
   * The profile ID.
   */
  protected string $id;

  /**
   * The profile label.
   */
  protected string $label;

  /**
   * Whether to display multiple elements as a gallery.
   */
  protected bool $gallery = TRUE;

  /**
   * Attribute used to group elements.
   */
  protected string $gallery_hook = 'rel';

  /**
   * Whether to track DOM changes dynamically.
   */
  protected bool $live_elements = TRUE;

  /**
   * Whether to preload all images on document ready.
   */
  protected bool $preload_all = FALSE;

  /**
   * Force elements type globally.
   */
  protected string $global_type = '';

  /**
   * Whether to create browser history and unique URLs.
   */
  protected bool $deeplink = FALSE;

  /**
   * Whether to enable images zooming system.
   */
  protected bool $img_zoom = FALSE;

  /**
   * Whether to enable element comments system.
   */
  protected bool $comments = FALSE;

  /**
   * Attribute containing element's source.
   */
  protected string $src_attr = 'href';

  /**
   * Attribute containing element's title.
   */
  protected string $title_attr = 'title';

  /**
   * Attribute containing element's description.
   */
  protected string $txt_attr = 'data-lcl-txt';

  /**
   * Attribute containing element's author.
   */
  protected string $author_attr = 'data-lcl-author';

  /**
   * Text used before the author's name.
   */
  protected string $author_by_txt = 'by';

  /**
   * Whether to enable slideshow system.
   */
  protected bool $slideshow = TRUE;

  /**
   * Animation duration for lightbox opening and closing (milliseconds).
   */
  protected int $open_close_time = 500;

  /**
   * Overlay's animation advance/delay to window (milliseconds).
   */
  protected int $ol_time_diff = 100;

  /**
   * Elements fading animation duration (milliseconds).
   */
  protected int $fading_time = 150;

  /**
   * Sizing animation duration (milliseconds).
   */
  protected int $animation_time = 300;

  /**
   * Slideshow interval duration (milliseconds).
   */
  protected int $slideshow_time = 6000;

  /**
   * Whether to autoplay slideshow.
   */
  protected bool $autoplay = FALSE;

  /**
   * Whether to display elements counter.
   */
  protected bool $counter = FALSE;

  /**
   * Whether to display progressbar when slideshow runs.
   */
  protected bool $progressbar = TRUE;

  /**
   * Whether to create non-stop pagination cycling elements.
   */
  protected bool $carousel = TRUE;

  /**
   * Lightbox maximum width (% or px).
   */
  protected string $max_width = '93%';

  /**
   * Lightbox maximum height (% or px).
   */
  protected string $max_height = '93%';

  /**
   * Lightbox wrapping padding CSS value.
   */
  protected string $wrap_padding = '';

  /**
   * Lightbox overlay's opacity.
   */
  protected float $ol_opacity = 0.7;

  /**
   * Lightbox overlay's color.
   */
  protected string $ol_color = '#111';

  /**
   * Lightbox overlay's pattern name or empty for none.
   */
  protected string $ol_pattern = '';

  /**
   * Lightbox border's width (pixels).
   */
  protected int $border_w = 0;

  /**
   * Lightbox border's color.
   */
  protected string $border_col = '#ddd';

  /**
   * Lightbox contents padding (pixels).
   */
  protected int $padding = 0;

  /**
   * Lightbox borders radius (pixels).
   */
  protected int $radius = 0;

  /**
   * Whether to apply shadow around lightbox window.
   */
  protected bool $shadow = TRUE;

  /**
   * Whether to hide page's vertical scroller on lightbox opening.
   */
  protected bool $remove_scrollbar = TRUE;

  /**
   * Custom classes added to wrapper.
   */
  protected string $wrap_class = '';

  /**
   * Skin applied to lightbox.
   */
  protected string $skin = 'light';

  /**
   * Where elements data will be shown.
   */
  protected string $data_position = 'over';

  /**
   * Where commands have to be shown.
   */
  protected string $cmd_position = 'inner';

  /**
   * Closing button's position.
   */
  protected string $ins_close_pos = 'normal';

  /**
   * Navigation buttons position.
   */
  protected string $nav_btn_pos = 'normal';

  /**
   * Whether to hide texts on lightbox opening (threshold or FALSE).
   */
  protected $txt_hidden = 500;

  /**
   * Whether to display titles.
   */
  protected bool $show_title = TRUE;

  /**
   * Whether to display descriptions.
   */
  protected bool $show_descr = TRUE;

  /**
   * Whether to display authors.
   */
  protected bool $show_author = TRUE;

  /**
   * Whether to enable thumbnails navigation.
   */
  protected bool $thumbs_nav = TRUE;

  /**
   * Whether to print type icons on thumbs.
   */
  protected bool $tn_icons = TRUE;

  /**
   * Whether to hide thumbs navigation (threshold or FALSE).
   */
  protected $tn_hidden = 500;

  /**
   * Thumbnails width (pixels).
   */
  protected int $thumbs_w = 110;

  /**
   * Thumbnails height (pixels).
   */
  protected int $thumbs_h = 110;

  /**
   * Element's attribute name containing thumbnail's URL.
   */
  protected string $thumb_attr = '';

  /**
   * Thumbnail maker URL with placeholders.
   */
  protected string $thumbs_maker_url = '';

  /**
   * Whether to allow fullscreen mode.
   */
  protected bool $fullscreen = TRUE;

  /**
   * Fullscreen image behavior.
   */
  protected string $fs_img_behavior = 'fit';

  /**
   * Whether to use only fullscreen mode (threshold or FALSE).
   */
  protected $fs_only = 500;

  /**
   * Whether to use browser fullscreen mode.
   */
  protected bool $browser_fs_mode = TRUE;

  /**
   * Whether to show social share button.
   */
  protected bool $socials = TRUE;

  /**
   * Facebook direct share parameters.
   */
  protected string $fb_direct_share = '';

  /**
   * Whether to show element's text toggle button.
   */
  protected bool $txt_toggle_cmd = TRUE;

  /**
   * Whether to show element's file download button.
   */
  protected bool $download = FALSE;

  /**
   * Whether to autoplay videos.
   */
  protected bool $autoplay_videos = FALSE;

  /**
   * Whether to enable touch interactions.
   */
  protected bool $touchswipe = TRUE;

  /**
   * Whether to enable elements navigation with mousewheel.
   */
  protected bool $mousewheel = TRUE;

  /**
   * Whether to enable modal mode.
   */
  protected bool $modal = FALSE;

  /**
   * Whether to prevent right click on lightbox elements.
   */
  protected bool $rclick_prevent = FALSE;

  /**
   * Opening/closing effect.
   */
  protected string $opening_effect = 'fade';

}
