<?php

namespace Drupal\ldap_auth\Form;

use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\CloseDialogCommand;
use Drupal\Core\Ajax\MessageCommand;
use Drupal\Core\Ajax\RedirectCommand;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\ldap_auth\MiniorangeLDAPConstants;
use Drupal\ldap_auth\MiniorangeLdapSupport;
use Drupal\ldap_auth\Utilities;
use Drupal\miniorange_oauth_client\MoConstant\MoModuleConstant;

class NotifyUsForm extends LDAPFormBase
{
  public function getFormId() {
    return 'mo_ldap_auth_notify_popup';
  }
  public function buildForm(array $form, FormStateInterface $form_state, $content_type = NULL) {
    $form['#prefix'] = '<div id="modal_support_form">';
    $form['#suffix'] = '</div>';
    $form['status_messages'] = [
      '#type' => 'status_messages',
      '#weight' => -10,
    ];

    $form['markup_library'] = [
      '#attached' => [
        'library' => [
          "ldap_auth/ldap_auth.admin",
          "core/drupal.ajax",
          "core/drupal.dialog.ajax",
        ],
      ],
    ];

    $user_email = Utilities::getCustomerEmail();

    $form['email_address'] =[
      '#type' => 'email',
      '#title' => t('Email'),
      '#default_value' => $user_email,
      '#required' => TRUE,
      '#attributes' => [
        'placeholder' => $this->t('Enter a valid email'),
        'style' => 'width:100%;margin-bottom:1%;',
      ],
    ];

    $form['support_number'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Phone Number'),
      '#attributes' => [
        'placeholder' => $this->t('Enter your Phone Number'),
        'style' => 'width:100%;margin-bottom:1%;',
      ],
    ];

    $form['support_query'] = [
      '#type' => 'textarea',
      '#required' => TRUE,
      '#title' => $this->t('Query \ Issue \ Use Case'),
      '#attributes' => [
        'placeholder' => $this->t('Describe your Message here!'),
        'style' => 'width:100%',
      ],
      '#rows' => 2
    ];

    $form['actions'] = ['#type' => 'actions'];

    $form['actions']['close'] = [
      '#type' => 'button',
      '#value' => $this->t('Skip'),
      '#attributes' => [
        'class' => ['button', 'dialog-cancel'],
        'style' => 'margin-right:8px',
      ],
      '#limit_validation_errors' => [],
      '#executes_submit_callback' => FALSE,
      '#validate' => [],
      '#submit' => [],
      '#ajax' => [
        'callback' => '::closeNotifyUsAjax',
        'wrapper' => 'modal_support_form',
        'event' => 'click',
      ],
    ];

    $form['actions']['send'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
      '#ajax' => [
        'callback' => '::submitNotifyUsFormAjax',
        'wrapper' => 'modal_support_form',
        'event' => 'click',
      ],
    ];

    return $form;
  }

  /**
   *
   */
  public function submitNotifyUsFormAjax(array &$form, FormStateInterface $form_state){
    $response = new AjaxResponse();
    $values = $form_state->getValues();

    $email = $values['email_address'] ?? '';
    $phone = $values['support_number'] ?? '';
    $query = $values['support_query'] ?? '';

    if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
      $response->addCommand(new MessageCommand(
        $this->t('Please enter a valid email address.'),
        NULL,
        ['type' => 'error']
      ));
      return $response;
    }

    if (empty($query)) {
      $response->addCommand(new MessageCommand(
        $this->t('Query field is required.'),
        NULL,
        ['type' => 'error']
      ));
      return $response;
    }

    $support = new MiniorangeLdapSupport($email, $phone, $query, 'notify_us');
    [$api_response, $status_code] = $support->sendSupportQuery();

    if ($status_code !== 200) {
      $response->addCommand(new MessageCommand(
        $this->t('Unable to send message. Please contact us at <a href="mailto:@mail">@mail</a>.', [
          '@mail' => MiniorangeLDAPConstants::SUPPORT_EMAIL,
        ]),
        NULL,
        ['type' => 'error']
      ));
      return $response;
    }
    \Drupal::state()->set('notify_us_pop_up_closed', TRUE);

    $response->addCommand(new MessageCommand(
      $this->t('Thank you for your feedback! Our support team will contact you soon.'),
      NULL,
      ['type' => 'status']
    ));

    $response->addCommand(new CloseDialogCommand());
    return $response;
  }

  public function closeNotifyUsAjax(array &$form, FormStateInterface $form_state) {
    $response = new AjaxResponse();
    \Drupal::state()->set('notify_us_pop_up_closed', TRUE);
    $response->addCommand(new CloseDialogCommand());
    return $response;
  }


  /**
   *
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {}


}
