(function ($, Drupal) {
  'use strict';

  // Initialize leadsms store.
  window.addEventListener('alpine:init', () => {
    Alpine.store('leadsms', {
      form: {
        name: '',
        phone: '',
        message: '',
      },
      submitting: 0,
      invalid: 0,
      thank_you: 0,
      messageError: null,
      loading: 1,
      showPoweredBy: 1,
      errors: [],

      onSubmit() {
        this.errors = [];
        this.invalid = 0;
        this.submitting = 1;

        // Validation
        if (!this.form.name) {
          this.errors.push('name');
        }
        if (!this.form.phone || this.form.phone === '1') {
          this.errors.push('phone');
        }
        if (!this.form.message.trim()) {
          this.errors.push('message');
        }

        if (this.errors.length > 0) {
          this.invalid = 1;
          this.submitting = 0;
          return;
        }

        // Perform the AJAX request
        $.ajax({
          url: '/leadsms_text/send-message',
          method: 'POST',
          data: {
            form: this.form,
            // csrf_token: csrf,
          },
          success: (response) => {
            this.invalid = 0;
            this.submitting = 0;
            this.thank_you = 1;
            this.messageError = null;

            setTimeout(() => {
              this.thank_you = 0;
              this.form.message = '';
            }, 12000);
          },
          error: (error) => {
            console.log('Error:', error);
            this.submitting = 0;
            this.thank_you = 0;
            this.messageError = error.responseJSON.message;
          },
        });
      },

      phFormat() {
        let ph = this.form.phone.replace(/[\D]+/g, '');
        if (ph.substr(0, 1) !== '1') {
          ph = '1' + ph;
        }
        let phArr = ph.split('', 11);
        let inserts = [' (', '', '', ') ', '', '', '-', '', '', '', ''];
        ph = '';
        for (let i = 0; i < phArr.length; i++) {
          ph += phArr[i] + inserts[i];
        }
        this.form.phone = ph;
      },
    });
  });

  /**
   * Makes sure drupal and alpine execute in the right order.
   */
  function waitForAlpineInit(callback) {
    if (window.Alpine && window.Alpine.store) {
      callback();
    } else {
      window.addEventListener('alpine:init', () => {
        callback();
      });
    }
  }

  Drupal.behaviors.leadsmsBehavior = {
    attach: function (context, settings) {
      once('leadsmsAlpineInit', 'html', context).forEach(function () {
        waitForAlpineInit(() => {
          if (typeof drupalSettings.leadsms !== 'undefined') {
            updateWidgetState(settings);
          }
        });
      });

      if ($('#actions-wrapper', context).length) {
        if (typeof drupalSettings.leadsms !== 'undefined') {
          updateWidgetState(settings);
        }
      }
      // hack to fix double messages
      let messagesList = $('.messages-list');

      // If there are more than one messages-list elements, remove the first one.
      if (messagesList.length > 1) {
        // Remove the first messages-list element.
        messagesList.first().remove();
      }
    },
  };

  function updateWidgetState(settings) {
    if (window.Alpine && window.Alpine.store) {
      Object.assign(window.Alpine.store('leadsms'), {
        header_text: settings.leadsms.header_text,
        widget_width: settings.leadsms.widget_width,
        widget_height: settings.leadsms.widget_height,
        header_bg: settings.leadsms.header_bg,
        header_text_color: settings.leadsms.header_text_color,
        submit_bg: settings.leadsms.submit_bg,
        submit_text: settings.leadsms.submit_text,
        body_bg: settings.leadsms.body_bg,
        launcher_bg: settings.leadsms.launcher_bg,
        launcher_text_color: settings.leadsms.launcher_text_color,
        popover: settings.leadsms.popover,
        popover_text: settings.leadsms.popover_text,
        popover_delay: settings.leadsms.popover_delay,
        hide_powered_by: settings.leadsms.hide_powered_by,
        loading: 0,
      });
    }
  }

  $(function () {
    /** When launcher is load */
    let $container = jQuery('.leadsms-widget-container'),
      $prompt_delay = parseFloat($container.data('prompt-delay')),
      $prompt_enabled = parseInt($container.data('prompt-enabled'));

    if ($prompt_enabled) {
      let $prompt_delay_in_ms = 1000;
      if (!isNaN($prompt_delay)) {
        $prompt_delay_in_ms = $prompt_delay * 1000;
      }

      setTimeout(() => {
        if (!$container.hasClass('widget-opened')) {
          let $prompt = $container.find('.leadsms-widget-prompt');
          $prompt.removeClass('hidden');
        }
      }, $prompt_delay_in_ms);
    }

    /** When launcher is clicked */
    jQuery('.leadsms-widget-launcher-icon').click(() => {
      let $container = jQuery('.leadsms-widget-container');
      $container.toggleClass('widget-opened');

      if ($container.hasClass('widget-opened')) {
        $container.find('.leadsms-widget-prompt').addClass('hidden');
        $container.find('.leadsms-widget-launcher-icon-message').addClass('hidden');
        $container
          .find('.leadsms-widget-launcher-icon-close')
          .removeClass('hidden');
      } else {
        $container
          .find('.leadsms-widget-launcher-icon-message')
          .removeClass('hidden');
        $container.find('.leadsms-widget-launcher-icon-close').addClass('hidden');
      }
    });

    /** When prompt is clicked */
    jQuery('.leadsms-widget-prompt .close-button').click(() => {
      let $container = jQuery('.leadsms-widget-container');
      let $prompt = $container.find('.leadsms-widget-prompt');
      $prompt.addClass('hidden');
    });
  });

})(jQuery, Drupal);
