<?php

namespace Drupal\leadsms_text\Controller;

use Drupal\Component\Utility\Html;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use GuzzleHttp\ClientInterface;
use Http\Client\Exception\RequestException;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for LEADsms routes.
 */
final class LeadSmsController extends ControllerBase {

  /**
   * The HTTP client service.
   *
   * @var \GuzzleHttp\ClientInterface
   */
  protected $httpClient;

  /**
   * The logger service.
   *
   * @var \Drupal\Core\Logger\LoggerChannelFactoryInterface
   */
  protected $loggerFactory;

  /**
   * The configuration factory service.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new LeadSmsController.
   *
   * @param \GuzzleHttp\ClientInterface $http_client
   *   The HTTP client service.
   * @param \Drupal\Core\Logger\LoggerChannelFactoryInterface $logger_factory
   *   The logger service.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The configuration factory service.
   */
  public function __construct(ClientInterface $http_client, LoggerChannelFactoryInterface $logger_factory, ConfigFactoryInterface $config_factory) {
    $this->httpClient = $http_client;
    $this->loggerFactory = $logger_factory;
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('http_client'),
      $container->get('logger.factory'),
      $container->get('config.factory')
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke(Request $request) {
    // @todo maybe csrf tokens.
    /*$token = $request->request->get('csrf_token');
    if (!$this->csrfToken->validate(
    $token,
    'leadsms_generic_token')) {
    return new JsonResponse([
    'success' => FALSE,
    'message' => 'Invalid token',
    ], 400);
    }*/

    // Check for POST data.
    $form = $request->request->all()['form'] ?? NULL;
    if ($form) {
      // Sanitize input.
      $sender = isset($form['name']) ? Html::escape($form['name']) : "";
      $phone = isset($form['phone']) ? Html::escape($form['phone']) : "";
      $message = isset($form['message']) ? Html::escape($form['message']) : "";

      if ($sender && $phone && $message) {
        $fromPhone = str_replace(["(", ")", " "], "-", $phone);

        $hostURL = 'https://connectsms.ca';

        try {
          // Fetch the license key from configuration.
          $licenseKey = $this->configFactory->get('leadsms_text.settings')
            ->get('license.license_key');

          // Make the POST request using the injected HTTP client.
          $response = $this->httpClient->post($hostURL . '/_LEADsms_in_Wrapper.php', [
            'form_params' => [
              'AccountSid' => 'AC23ac30f38763217a1d1c039661015050',
              'AccountID' => $licenseKey,
              'Body' => $message,
              'From' => '+' . $fromPhone,
              'Name' => $sender,
            ],
          ]);

          $body = $response->getBody()->getContents();
          return new JsonResponse(json_decode($body));
        }
        catch (RequestException $e) {
          $this->loggerFactory->get('leadsms_text')->error($e->getMessage());
          return new JsonResponse([
            'success' => FALSE,
            'message' => 'Error sending the message',
          ], 400);
        }
      }
      else {
        return new JsonResponse([
          'success' => FALSE,
          'message' => 'Invalid form',
        ], 400);
      }
    }
    else {
      return new JsonResponse([
        'success' => FALSE,
        'message' => 'Empty form',
      ], 400);
    }
  }

}
