# Leaflet Dynamic Table

A Drupal module that provides a dynamic attachment display for Leaflet Map Views
that updates based on the map viewport.

## Description

This module extends the Leaflet Views module by adding a new display type called
"Leaflet Dynamic Attachment". When attached to a Leaflet map display, this
attachment automatically updates to show only the items currently visible within
the map viewport.

As users pan and zoom the map, the attachment table dynamically refreshes via
AJAX to display only the entities whose markers are within the visible bounds.

## Features

- Dynamic filtering based on map viewport bounds
- Configurable update triggers (zoom, pan, or both)
- Configurable debounce delay to prevent excessive AJAX requests
- Clean Views UI integration with unnecessary options hidden
- Proper access control and input validation
- Works with any entity type that has geographic coordinates

## Requirements

- Drupal 10.x or 11.x
- Views (Drupal core)
- [Leaflet](https://www.drupal.org/project/leaflet)
- [Leaflet Views](https://www.drupal.org/project/leaflet) (included with Leaflet)

## Installation

1. Install the module using Composer:

   ```
   composer require drupal/leaflet_dynamic_table
   ```

2. Enable the module:
   ```
   drush en leaflet_dynamic_table
   ```

## Configuration

1. Create or edit a View that displays entities with geographic coordinates.

2. Add a Page or Block display with the "Leaflet Map" format.

3. Add a new display of type "Leaflet Dynamic Attachment".

4. In the attachment settings, configure:

   - **Attach to Leaflet map**: Select which map display(s) to attach to.
   - **Map display**: Select the Leaflet map display to respond to.
   - **Dynamic settings**: Configure update behavior:
     - Update on zoom (default: enabled)
     - Update on pan (default: enabled)
     - Debounce delay in milliseconds (default: 300ms)

5. Configure the attachment's format (Table, Unformatted list, etc.) and fields.

6. Save the View.

## How It Works

1. When a page with a Leaflet map and dynamic attachment loads, JavaScript
   initializes and binds to the map's zoom and move events.

2. When the map viewport changes (zoom or pan), the JavaScript collects all
   entity IDs from markers currently visible within the map bounds.

3. An AJAX request sends these entity IDs to the server.

4. The server filters the View results to only include entities matching
   these IDs and returns the rendered HTML.

5. The attachment container updates with the new filtered content.

## Security

- All input parameters are validated and sanitized.
- View access permissions are checked before rendering.
- Entity IDs are cast to integers to prevent SQL injection.
- AJAX endpoints respect Drupal's access control system.

## Troubleshooting

**The attachment shows all items instead of filtering:**

- Ensure the attachment is set to attach to a Leaflet map display.
- Verify the map display uses the "Leaflet Map" format.
- Check browser console for JavaScript errors.

**The attachment doesn't update when panning/zooming:**

- Verify JavaScript is loading (check for console messages).
- Ensure the debounce delay is set appropriately.
- Check that update on zoom/pan options are enabled.

## Maintainers

Current maintainers:

- [Oleg Ivanov](https://www.drupal.org/u/oivanov)

## License

This project is licensed under the GPL-2.0-or-later license.
See the [LICENSE.txt](LICENSE.txt) file for details.
