<?php

namespace Drupal\Tests\league_oauth_login_gitlab\Kernel;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Drupal\KernelTests\KernelTestBase;
use Drupal\league_oauth_login\Controller\LoginController;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class LoginTest.
 *
 * @group league_oauth_login
 */
class IdentityProviderExceptionTest extends KernelTestBase implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public static $modules = [
    'user',
    'externalauth',
    'league_oauth_login_gitlab',
    'league_oauth_login',
  ];

  /**
   * Test that the message is displayed if it is possible to see.
   */
  public function testExceptionWithMessage() {
    $request = Request::createFromGlobals();
    $request->query->set('code', 123);
    $state = rand();
    $this->container->get('session')->set('oauth2state', $state);
    $request->query->set('state', $state);
    $controller = LoginController::create($this->container);
    $response = $controller->login($request, 'bogus');
    $response_string = (string) $this->container->get('renderer')->renderRoot($response);
    $this->assertEqual($response_string, 'There was a problem logging you in.');
    $messages = $this->container->get('messenger')->all();
    $this->assertEqual($messages["error"][0], TestGitlabProvider::ERROR_MESSAGE);
  }

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $def = $container->getDefinition('plugin.manager.league_oauth_login');
    $def->setClass(TestProviderManager::class);
    $container->setDefinition('plugin.manager.league_oauth_login', $def);
  }

}
