<?php

namespace Drupal\Tests\league_oauth_login\Kernel;

use Drupal\Component\Utility\UrlHelper;
use Drupal\Core\Routing\TrustedRedirectResponse;
use Drupal\Core\Url;
use Drupal\KernelTests\KernelTestBase;
use Drupal\league_oauth_login\Controller\LoginController;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class Login test base.
 */
abstract class LoginTestBase extends KernelTestBase {

  /**
   * The name of the provider we are trying to use.
   *
   * @var string
   */
  protected $providerId;

  /**
   * {@inheritdoc}
   */
  public static $modules = [
    'user',
    'league_oauth_login',
    'externalauth',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp() {
    parent::setUp();

    // Create some config for the provider we are testing.
    $this->createConfigForProvider();
  }

  /**
   * Create config for the provider.
   */
  protected function createConfigForProvider() {
    /** @var \Drupal\Core\Config\Config $config */
    $config = $this->container->get('config.factory')->getEditable('league_oauth_login_' . $this->providerId . '.settings');
    $config->setData([
      'clientId' => rand(),
      'clientSecret' => rand(),
      'redirectUri' => Url::fromRoute('league_oauth_login.login_controller_login', [
        'provider_id' => $this->providerId,
      ], [
        'absolute' => TRUE,
      ])->toString(),
    ]);
    $config->save();
  }

  /**
   * Test that we can log in and get a user created.
   */
  public function testLoginUserRedirected() {
    $request = Request::createFromGlobals();
    $controller = LoginController::create($this->container);
    $response = $controller->login($request, $this->providerId);
    self::assertInstanceOf(TrustedRedirectResponse::class, $response);
    $url = $response->getTargetUrl();
    $parsed = UrlHelper::parse($url);
    $this->assertEqual($parsed["query"]["redirect_uri"], Url::fromRoute('league_oauth_login.login_controller_login', [
      'provider_id' => $this->providerId,
    ], [
      'absolute' => TRUE,
    ])->toString());
    $this->assertEqual($parsed["path"], $this->getProviderPath());
  }

  /**
   * This should return the expected path when redirected to the provider.
   */
  abstract protected function getProviderPath();

}
