(function ($, Drupal, drupalSettings) {
  'use strict';
  Drupal.behaviors.confirmLeave = {
    attach: function (context, settings) {

      if (drupalSettings.leave_confirm && drupalSettings.leave_confirm.formId) {
        // Access the form ID.
        var formId = drupalSettings.leave_confirm.formId;

        $(formId).find('.form-item').on('formUpdated', function (e) {
          $('form').addClass('form-updated');

          // Set up the before unload event.
          window.onbeforeunload = function (e) {
            var dialogText = 'You have unsaved changes on this page. Are you sure you want to leave?';
            e.returnValue = dialogText;  // Standard for most browsers
            return dialogText;           // For some browsers (e.g. older versions of Firefox)
          };

          // Remove the beforeunload handler when the form is submitted.
          $('form').on('submit', function (e) {
            window.onbeforeunload = null;
          });
        });
      }
    }
  };
}(jQuery, Drupal, drupalSettings));
