(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.confirmLeave = {
    attach(context, settings) {
      if (drupalSettings.leave_confirm && drupalSettings.leave_confirm.formId) {
        // Access the form ID.
        const formId = drupalSettings.leave_confirm.formId;
        const $form = $(formId);
        $(formId)
          .find('.form-item')
          .on('formUpdated', function (e) {
            $form.addClass('form-updated');

            // Set up the before unload event.
            window.onbeforeunload = function (e) {
              const dialogText =
                'You have unsaved changes on this page. Are you sure you want to leave?';
              e.returnValue = dialogText; // Standard for most browsers
              return dialogText; // For some browsers (e.g. older versions of Firefox)
            };

            // Remove the beforeunload handler when the form is submitted.
            $form.on('submit', function (e) {
              window.onbeforeunload = null;
            });
          });
      }

      // Handle media library form elements - when media is added or removed.
      if (
        context.classList &&
        (context.classList.contains('js-media-library-widget') ||
          context.classList.contains('media-library-form-element'))
      ) {
        $(context).trigger('formUpdated');
      }
    },
  };

  // Handle tabledrag changes.
  if (Drupal.tableDrag) {
    const _onDrop = Drupal.tableDrag.prototype.onDrop;
    Drupal.tableDrag.prototype.onDrop = function (...args) {
      // Do standard onDrop.
      _onDrop.apply(this, args);
      // Trigger the formUpdated event whenever a row is dropped.
      $('.form-item', this.rowObject.element).trigger('formUpdated');
    };
  }
})(jQuery, Drupal, drupalSettings);
