Leave Confirm
=============

The **Leave Confirm** module enhances the user experience on Drupal
websites by providing a configurable popup confirmation dialog when
users attempt to leave a page without saving changes in specified
forms. This module ensures that important form data is not
accidentally lost and allows users to confirm their intention
before navigating away.

Table of Contents
-----------------

*   [Requirements](#requirements)
*   [Installation](#installation)
*   [Configuration](#configuration)
*   [How to Use](#usage)
*   [Maintainers](#maintainers)

Requirements
------------

*   Drupal 10 or higher
*   Administrator access to configure module settings

Installation
------------

Install the Leave Confirm module via Composer:

    composer require drupal/leave_confirm

Alternatively, you can install it like a standard contributed
Drupal module. See the [Drupal documentation](https://www.drupal.org/docs/10/extending-drupal/installing-modules) for detailed instructions.

Configuration
-------------

1.  Go to **Administration » Extend** and enable the Leave Confirm module.
2.  Navigate to **Configuration » User interface » Leave confirm
configuration** to access the module's settings.

### Settings

*   **Enable/Disable Form Points:** Admins can enable or disable the
Leave Confirm feature for each configured form.
*   **Add New Form Points:** Add new forms to be tracked by the module
for confirmation popups.
*   **Permissions:** Control which user roles can manage Leave Confirm settings.

How to Use
----------

1.  Install and enable the Leave Confirm module.
2.  Configure Leave Confirm settings for default forms or add new form
points as needed. Access the settings at **Administration » Configuration
» User interface » Leave confirm configuration**.
3.  Fine-tune permissions for user roles to control access to the Leave
Confirm configuration.
4.  Enjoy an enhanced user experience with the added layer of confirmation
before leaving forms.

Key Features
------------

1.  **Configurable Leave Confirm Dialogs:** Easily configure the Leave
Confirm feature for specific forms across the site to protect important
form data.
2.  **Granular Permissions:** Control which roles can configure the Leave
Confirm feature for specific forms.
3.  **Default Configuration:** Automatically adds points for common forms
(user forms, node forms, webform forms) on installation.
4.  **Enable/Disable Functionality:** Enable or disable the Leave Confirm
feature per form point as needed.
5.  **Add New Form Points:** Administrators can add new forms for Leave
Confirm to monitor.
6.  **User-Friendly Interface:** Manage leave confirmation settings via the
administrative interface at **admin/config/user-interface/leave-confirm-points**.

Maintainers
-----------

This module is maintained by **Sujan Shrestha** - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha).
