# Library Renderer
The library renderer provides component and DOM level rendering of libraries.

Using component level rendering will increase page speed by only attaching libraries as and when required.

## Description
The module provides four options for attaching a library:

<ol>
  <li>html_tags: Attaches a library when HTML output contains a matching DOM element.</li>
  <li>templates: Attaches a library when an exact match template.html.twig file is found.</li>
  <li>theme_hooks: Attaches a library when a theme hook is invoked.</li>
  <li>theme_suggestions: Provides fuzzy template matching against template suggestions.</li>
</ol>

## Requirements

Drupal core is the only requirement for this module.

## Installation

Install as you would normally install a contributed Drupal module.
Visit https://www.drupal.org/node/1897420 for further information.

## Example usage

* Edit library YML definition.
* Add YML library_renderer definition to automatically load the library based on supplied render types.

```
example_library:
  css:
    component:
      theme/dist/example.css: { minified: true }
  js:
    theme/dist/example.js: { minified: true }
  dependencies:
    - core/jquery
  library_renderer:
    html_tags:
      pre: { }
      code: { attributes: { class: 'language-php' } }
    templates:
      - field.html.twig
      - foo.html.twig
    theme_hooks:
      - input__submit
      - block
    theme_suggestions:
      - field__paragraph__example
      - field__foo

```


## Maintainers
* Bart Vanhoutte (Bart Vanhoutte) - https://www.drupal.org/user/1133754
* Alex Moreno - https://www.alexmoreno.net - https://www.drupal.org/u/alexmoreno
