<?php

namespace Drupal\library_renderer\Theme;

use Drupal\Core\Theme\ThemeManager;

/**
 * Custom ThemeManager to expose the protected buildThemeHookSuggestions method.
 */
class LibraryRendererThemeManager extends ThemeManager {

  /**
   * Public method to expose the protected buildThemeHookSuggestions method.
   *
   * @param string $hook
   *   The base hook for theme suggestions.
   * @param string $info_base_hook
   *   The base hook of the template file.
   * @param array $variables
   *   The variables available in the theme.
   *
   * @return array
   *   The theme hook suggestions.
   */
  public function getThemeHookSuggestions(string $hook, string $info_base_hook, array &$variables): array {
    return $this->buildThemeHookSuggestions($hook, $info_base_hook, $variables);
  }

}
