<?php

namespace Drupal\lightgallery_formatter\Plugin\Lightgallery;

/**
 * General plugin settings implementation.
 */
class LightgalleryGeneralSettings {

  /**
   * Get the plugin identifier.
   */
  public function getPluginId(): string {
    return 'general';
  }

  /**
   * Get default settings for this plugin.
   */
  public function getDefaultSettings(): array {
    return [
      'loop' => TRUE,
      'preload' => 2,
      'speed' => 400,
      'mode' => 'lg-slide',
      'closable' => TRUE,
      'closeOnTap' => TRUE,
      'escKey' => TRUE,
      'keyPress' => TRUE,
      'showCloseIcon' => TRUE,
      'showMaximizeIcon' => FALSE,
      'hideBarsDelay' => 0,
      'counter' => TRUE,
      'download' => TRUE,
      'enableDrag' => TRUE,
      'enableSwipe' => TRUE,
      'mousewheel' => FALSE,
    ];
  }

  /**
   * Validate settings before saving.
   */
  public function validateSettings(array $settings): bool {
    // Validate general settings.
    if (isset($settings['preload']) && (!is_numeric($settings['preload']) || $settings['preload'] < 0)) {
      return FALSE;
    }
    if (isset($settings['speed']) && (!is_numeric($settings['speed']) || $settings['speed'] < 0)) {
      return FALSE;
    }
    if (isset($settings['hideBarsDelay']) && (!is_numeric($settings['hideBarsDelay']) || $settings['hideBarsDelay'] < 0)) {
      return FALSE;
    }

    return TRUE;
  }

  /**
   * Apply settings to lightgallery configuration.
   */
  public function applyToConfiguration(array $configuration, array $settings): array {
    // Merge general settings into lightgallery configuration.
    return array_merge($configuration, $settings);
  }

}
