<?php

namespace Drupal\lightgallery_formatter\Plugin\Lightgallery;

/**
 * Thumbnail plugin settings implementation.
 */
class LightgalleryThumbnailSettings {

  /**
   * Get the plugin identifier.
   */
  public function getPluginId(): string {
    return 'thumbnail';
  }

  /**
   * Get default settings for this plugin.
   */
  public function getDefaultSettings(): array {
    return [
      'thumbnail' => TRUE,
      'animateThumb' => TRUE,
      'image_style' => '',
      'thumbMargin' => 5,
      'appendTo' => '',
      'showThumbByDefault' => TRUE,
    ];
  }

  /**
   * Validate settings before saving.
   */
  public function validateSettings(array $settings): bool {
    // Validate thumbnail settings.
    if (isset($settings['thumbMargin']) && (!is_numeric($settings['thumbMargin']) || $settings['thumbMargin'] < 0)) {
      return FALSE;
    }

    return TRUE;
  }

  /**
   * Apply settings to lightgallery configuration.
   */
  public function applyToConfiguration(array $configuration, array $settings): array {
    // Merge thumbnail settings into lightgallery configuration.
    return array_merge($configuration, $settings);
  }

}
