<?php

namespace Drupal\Tests\lightgallery_formatter\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests library definitions for LightGallery formatter.
 *
 * @group lightgallery_formatter
 */
class LightgalleryLibraryTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['lightgallery_formatter'];

  /**
   * The library discovery service.
   *
   * @var \Drupal\Core\Asset\LibraryDiscoveryInterface
   */
  protected $libraryDiscovery;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->libraryDiscovery = $this->container->get('library.discovery');
  }

  /**
   * Test that the main gallery library is defined.
   */
  public function testGalleryLibraryExists(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    $this->assertNotEmpty($library, 'Gallery library exists.');
    $this->assertArrayHasKey('js', $library, 'Gallery library has JavaScript.');
    $this->assertArrayHasKey('css', $library, 'Gallery library has CSS.');
    $this->assertArrayHasKey('dependencies', $library, 'Gallery library has dependencies.');
  }

  /**
   * Test local library definitions.
   */
  public function testLocalLibrariesExist(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'lightgallery.local');
    $this->assertNotEmpty($library, 'Local LightGallery library is defined.');
    $this->assertArrayHasKey('js', $library, 'Local library has JavaScript.');
    $this->assertArrayHasKey('css', $library, 'Local library has CSS.');

    $thumbnail_library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'lightgallery.local.thumbnail');
    $this->assertNotEmpty($thumbnail_library, 'Local thumbnail library is defined.');
  }

  /**
   * Test library dependencies are correctly defined.
   */
  public function testLibraryDependencies(): void {
    $gallery_library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    // Gallery library should depend on core libraries.
    $this->assertContains('core/jquery', $gallery_library['dependencies'], 'Gallery depends on jQuery.');
    $this->assertContains('core/drupal', $gallery_library['dependencies'], 'Gallery depends on Drupal.');
    $this->assertContains('core/once', $gallery_library['dependencies'], 'Gallery depends on once.');

    // Local thumbnail should depend on local base.
    $local_thumbnail = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'lightgallery.local.thumbnail');
    $this->assertContains('lightgallery_formatter/lightgallery.local', $local_thumbnail['dependencies'], 'Local thumbnail depends on local base library.');
  }

}
