# LightGallery Formatter

A Drupal module that provides a field formatter to display media image fields using the [LightGallery](https://www.lightgalleryjs.com/) JavaScript library.

## Features

- **Field Formatter for Media Fields**: Display entity reference fields (targeting media image bundles) as beautiful lightbox galleries.
- **Profile-based Configuration**: Create multiple reusable gallery profiles with different settings.
- **Plugin Architecture**: Modular system for LightGallery features (General settings, Thumbnail plugin, and more).
- **CDN or Local Library**: Choose between loading LightGallery from CDN (jsDelivr, cdnjs, unpkg) or local installation.
- **Image Style Support**: Apply Drupal image styles to gallery thumbnails.
- **Responsive Design**: Works seamlessly on desktop and mobile devices.
- **Remote Video Support**: Automatically extracts thumbnails from YouTube and Vimeo videos.

## Requirements

- Drupal 10.3+ or Drupal 11
- Media module (core)
- LightGallery JavaScript library v2.7+ (can be loaded via CDN or installed locally)

## Installation

### Using Composer (Recommended)

```bash
composer require drupal/lightgallery_formatter
drush en lightgallery_formatter -y
```

### Manual Installation

1. Download the module from [drupal.org/project/lightgallery_formatter](https://www.drupal.org/project/lightgallery_formatter)
2. Extract to `modules/contrib/lightgallery_formatter`
3. Enable via Admin UI or Drush: `drush en lightgallery_formatter -y`

### Installing LightGallery Library (Optional)

The module can load LightGallery from CDN by default. For local installation, choose one of these methods:

#### Option 1: Using Composer (Recommended)

Add to your project's `composer.json`:

```json
{
    "repositories": [
        {
            "type": "package",
            "package": {
                "name": "npm-asset/lightgallery",
                "version": "2.9.0",
                "type": "drupal-library",
                "dist": {
                    "url": "https://registry.npmjs.org/lightgallery/-/lightgallery-2.9.0.tgz",
                    "type": "tar"
                }
            }
        }
    ]
}
```

Then run:

```bash
composer require npm-asset/lightgallery:2.9.0
```

The library will be installed to `web/libraries/lightgallery/`.

#### Option 2: Manual Download

```bash
cd web/libraries
curl -sL https://registry.npmjs.org/lightgallery/-/lightgallery-2.9.0.tgz | tar -xz
mv package lightgallery
```

#### Verify Installation

Ensure these files exist:
- `web/libraries/lightgallery/lightgallery.umd.js`
- `web/libraries/lightgallery/css/lightgallery.css`
- `web/libraries/lightgallery/plugins/thumbnail/lg-thumbnail.umd.js` (for thumbnails)

## Configuration

### Step 1: Create a Gallery Profile

1. Navigate to **Structure → LightGallery Profiles** (`/admin/structure/lightgallery-profiles`)
2. Click **Add profile**
3. Configure general settings:
   - **Loop**: Enable infinite looping through images
   - **Speed**: Animation speed in milliseconds
   - **Mode**: Slide transition mode
   - **Controls**: Show/hide close, maximize, download buttons
4. Configure thumbnail settings (optional):
   - **Enable thumbnails**: Show thumbnail strip below the gallery
   - **Animate thumbnails**: Enable smooth thumbnail animations
   - **Thumbnail margin**: Spacing between thumbnails
5. Choose delivery method (CDN or Local)
6. Save the profile

### Step 2: Configure Your Field Display

1. Go to **Structure → Content types → [Your Type] → Manage display**
2. Find your media image field
3. Set the formatter to **LightGallery**
4. Click the gear icon to configure:
   - Select a **LightGallery Profile**
   - Choose **Thumbnail image style** for the grid view
   - Configure **Gallery item source** for each media type (optional)
5. Save

### Step 3: View Your Content

Create or view content with media images — they will now display as a LightGallery!

## Submodules

### LightGallery Formatter Demo

Provides demo content for testing the module with the `demo_umami` installation profile.

```bash
drush en lightgallery_formatter_demo -y
```

### LightGallery Formatter Preview

Provides a live preview feature when configuring gallery profiles.

```bash
drush en lightgallery_formatter_preview -y
```

## Similar Projects

- **[Colorbox](https://www.drupal.org/project/colorbox)** — Classic lightbox solution for Drupal
- **[PhotoSwipe](https://www.drupal.org/project/photoswipe)** — JavaScript gallery with gestures support
- **[GLightbox](https://www.drupal.org/project/glightbox)** — Modern lightbox with video support

## What Makes LightGallery Different?

- **Modern JavaScript**: Built with ES6, no jQuery dependency
- **Rich Feature Set**: Zoom, fullscreen, thumbnails, autoplay, share buttons
- **Video Support**: YouTube, Vimeo, and HTML5 video
- **Touch Gestures**: Swipe, pinch-to-zoom on mobile
- **Plugin System**: Modular architecture allows enabling only needed features

## Support

- **Issue queue**: [drupal.org/project/issues/lightgallery_formatter](https://www.drupal.org/project/issues/lightgallery_formatter)
- **Documentation**: [drupal.org/project/lightgallery_formatter](https://www.drupal.org/project/lightgallery_formatter)

## Credits

- **LightGallery Library**: [lightgalleryjs.com](https://www.lightgalleryjs.com/) by Sachin Neravath
- **Module Maintainer**: [man-1982](https://www.drupal.org/u/man-1982)

---

## For Developers

### Setting up a Local Development Environment using DDEV

The project uses [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib) addon to deploy and debug code.

**Prerequisites:**

* [Docker](https://docs.docker.com/get-docker/) installed.
* [DDEV](https://ddev.readthedocs.io/en/latest/users/install/ddev-installation/) installed.

### Quick Start (Recommended)

The fastest way to get up and running with a fully configured demo site:

```bash
# Clone the repository
git clone git@git.drupal.org:project/lightgallery_formatter.git
cd lightgallery_formatter

# Start DDEV
ddev start

# Initialize everything with one command
ddev lgf:init
```

This command will:
- Install Composer dependencies
- Symlink the module to Drupal
- Install Drupal with the **demo_umami** profile
- Enable the LightGallery Formatter module with demo content
- Enable Admin Toolbar for easier navigation
- Provide login credentials (`admin` / `admin`) and a one-time login link

### Manual Setup (Alternative)

If you prefer step-by-step control or need a custom installation:

1. **Clone and start DDEV:**
   ```bash
   git clone git@git.drupal.org:project/lightgallery_formatter.git
   cd lightgallery_formatter
   ddev start
   ```

2. **Install Composer dependencies:**
   ```bash
   ddev poser
   ```

3. **Install Drupal:**
   ```bash
   # Using standard profile
   ddev drush site:install --yes

   # OR using demo_umami profile for demo content
   ddev drush site:install demo_umami --yes
   ```

4. **Enable the module:**
   ```bash
   ddev drush en lightgallery_formatter -y
   ```

5. **Get a login link:**
   ```bash
   ddev drush user:login
   ```

### Useful Commands

| Command | Description |
|---------|-------------|
| `ddev lgf:init` | Full reset and fresh install with demo site |
| `ddev drush cr` | Clear Drupal caches |
| `ddev drush uli` | Get one-time admin login link |
| `ddev phpcs` | Check coding standards |
| `ddev phpcbf` | Auto-fix coding standard violations |
| `ddev phpstan` | Run static analysis |
| `ddev phpunit` | Run PHPUnit tests |
| `ddev describe` | Show project info and URLs |

### Working with composer.contrib.json

After running `ddev lgf:init`, the `composer.contrib.json` file is preserved for manual modifications. This file contains Drupal core and dev dependencies while keeping the module's `composer.json` clean for drupal.org publication.

**Add additional packages:**
```bash
ddev exec "COMPOSER=composer.contrib.json composer require drupal/devel"
```

**Update dependencies:**
```bash
ddev exec "COMPOSER=composer.contrib.json composer update"
```

**Why two composer files?**
- `composer.json` — Module dependencies only (published to drupal.org)
- `composer.contrib.json` — Development environment (Drupal core + dev tools + module)

### Architecture

The module uses a plugin-based architecture:

- `src/Entity/LightgalleryProfile.php` — Config entity for gallery profiles
- `src/Plugin/Field/FieldFormatter/LightGalleryFormatter.php` — Field formatter
- `src/Plugin/Lightgallery/` — Plugin classes for different features
- `js/lightgallery_formatter.behaviors.js` — Drupal behavior for initializing galleries
