/**
 * @file
 * JavaScript behaviors for LightGallery preview functionality.
 */

/* global lightGallery, lgThumbnail */

(function ($, Drupal, drupalSettings, once) {
  /**
   * Attach LightGallery preview behavior.
   */
  Drupal.behaviors.lightgalleryPreview = {
    attach(context, settings) {
      // Get preview settings from drupalSettings.
      const previewSettings = settings.lightgallery_preview;
      if (!previewSettings) {
        return;
      }

      const galleryId = previewSettings.gallery_id;
      const lgSettings = previewSettings.settings || {};

      // Find preview gallery container.
      const previewContainers = once(
        'lightgallery-preview',
        `#${galleryId}`,
        context,
      );

      previewContainers.forEach((container) => {
        // Destroy any existing LightGallery instance.
        if (container.lgData) {
          container.lgData.destroy(true);
        }

        // Small delay to ensure DOM is ready after AJAX.
        setTimeout(() => {
          // Check if lightGallery is available.
          if (typeof lightGallery === 'undefined') {
            console.warn('LightGallery library is not loaded.');
            return;
          }

          // Prepare plugins array.
          const plugins = [];

          // Add thumbnail plugin if enabled and available.
          if (
            lgSettings.enableThumbnail &&
            typeof lgThumbnail !== 'undefined'
          ) {
            plugins.push(lgThumbnail);
          }

          // Build final settings.
          const finalSettings = {
            ...lgSettings,
            plugins,
            selector: 'a',
            licenseKey: '0000-0000-000-0000',
          };

          // Initialize LightGallery.
          try {
            lightGallery(container, finalSettings);
          } catch (e) {
            console.error('Error initializing LightGallery preview:', e);
          }
        }, 100);
      });
    },
  };
})(jQuery, Drupal, drupalSettings, once);
