<?php

namespace Drupal\lightgallery_formatter\Entity;

/**
 * Interface for LightgalleryProfile entities.
 */
interface LightgalleryProfileInterface {

  /**
   * Gets the status.
   *
   * @return bool
   *   TRUE if enabled, FALSE otherwise.
   */
  public function getStatus(): bool;

  /**
   * Get plugin settings.
   *
   * @param string $plugin_id
   *   The plugin ID.
   *
   * @return array
   *   The plugin settings.
   */
  public function getPluginSettings(string $plugin_id): array;

  /**
   * Set plugin settings.
   *
   * @param string $plugin_id
   *   The plugin ID.
   * @param array $settings
   *   The plugin settings.
   */
  public function setPluginSettings(string $plugin_id, array $settings): void;

  /**
   * Get all plugin settings.
   *
   * @return array
   *   All plugin settings.
   */
  public function getAllPluginSettings(): array;

  /**
   * Get validated plugin settings with defaults.
   *
   * @param string $plugin_id
   *   The plugin ID.
   *
   * @return array
   *   Validated plugin settings.
   */
  public function getValidatedPluginSettings(string $plugin_id): array;

}
