<?php

namespace Drupal\lightgallery_formatter\Plugin\Lightgallery;

/**
 * Thumbnail plugin settings implementation.
 */
class LightgalleryThumbnailSettings {

  /**
   * Get default settings for this plugin.
   */
  public function getDefaultSettings(): array {
    return [
      'thumbnail' => TRUE,
      'animateThumb' => TRUE,
      'image_style' => '',
      'thumbMargin' => 5,
      'appendTo' => '',
      'showThumbByDefault' => TRUE,
    ];
  }

  /**
   * Validate settings before saving.
   */
  public function validateSettings(array $settings): bool {
    // Validate thumbnail settings.
    if (isset($settings['thumbMargin']) && (!is_numeric($settings['thumbMargin']) || $settings['thumbMargin'] < 0)) {
      return FALSE;
    }

    return TRUE;
  }

}
