<?php

namespace Drupal\lightgallery_formatter\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a LightGallery plugin annotation object.
 *
 * Plugin Namespace: Plugin\Lightgallery.
 *
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginManager
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginInterface
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginBase
 * @see plugin_api
 *
 * @Annotation
 */
class LightgalleryPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description = '';

  /**
   * The weight of the plugin (for ordering in UI).
   *
   * @var int
   */
  public $weight = 0;

}
