<?php

namespace Drupal\lightgallery_formatter\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a LightGallery plugin attribute object.
 *
 * Plugin Namespace: Plugin\Lightgallery.
 *
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginManager
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginInterface
 * @see \Drupal\lightgallery_formatter\LightgalleryPluginBase
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class LightgalleryPlugin extends Plugin {

  /**
   * Constructs a LightgalleryPlugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $description
   *   A brief description of the plugin.
   * @param int $weight
   *   The weight of the plugin (for ordering in UI).
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly TranslatableMarkup|string $description = '',
    public readonly int $weight = 0,
    public readonly ?string $deriver = NULL,
  ) {}

}

