<?php

namespace Drupal\lightgallery_formatter;

use Drupal\Component\Plugin\ConfigurableInterface;
use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\lightgallery_formatter\Entity\LightgalleryProfileInterface;

/**
 * Defines an interface for LightGallery plugins.
 *
 * LightGallery plugins provide configuration, form UI, and runtime settings
 * for specific LightGallery features (e.g., thumbnails, zoom, video).
 */
interface LightgalleryPluginInterface extends PluginInspectionInterface, ConfigurableInterface {

  /**
   * Gets the default settings for this plugin.
   *
   * @return array
   *   An array of default settings keyed by setting name.
   */
  public function defaultSettings(): array;

  /**
   * Builds the configuration form for this plugin.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   * @param \Drupal\lightgallery_formatter\Entity\LightgalleryProfileInterface $profile
   *   The profile entity being configured.
   *
   * @return array
   *   A form array for this plugin's settings.
   */
  public function buildForm(array &$form, FormStateInterface $form_state, LightgalleryProfileInterface $profile): array;

  /**
   * Validates the plugin configuration form.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void;

  /**
   * Handles form submission for this plugin.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   *
   * @return array
   *   The plugin settings to be saved.
   */
  public function submitForm(array &$form, FormStateInterface $form_state): array;

  /**
   * Builds the JavaScript settings for LightGallery initialization.
   *
   * @param array $settings
   *   The current plugin settings from the profile.
   *
   * @return array
   *   An array of settings to be passed to the LightGallery JavaScript.
   */
  public function buildJsSettings(array $settings): array;

  /**
   * Checks if this plugin is enabled in the given settings.
   *
   * @param array $settings
   *   The plugin settings.
   *
   * @return bool
   *   TRUE if the plugin is enabled, FALSE otherwise.
   */
  public function isEnabled(array $settings): bool;

}
