<?php

namespace Drupal\Tests\lightgallery_formatter\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests plugin enabled state for LightGallery plugins.
 *
 * @group lightgallery_formatter
 */
class LightgalleryPluginLibraryAttachTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['lightgallery_formatter'];

  /**
   * The plugin manager.
   *
   * @var \Drupal\lightgallery_formatter\Plugin\Lightgallery\LightgalleryPluginManager
   */
  protected $pluginManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(['lightgallery_formatter']);
    $this->pluginManager = $this->container->get('plugin.manager.lightgallery');
  }

  /**
   * Test isEnabled respects settings.
   */
  public function testIsEnabledRespectsSettings(): void {
    $thumbnail_enabled = $this->pluginManager->createInstance('thumbnail', ['enabled' => TRUE]);
    $thumbnail_disabled = $this->pluginManager->createInstance('thumbnail', ['enabled' => FALSE]);

    $this->assertTrue($thumbnail_enabled->isEnabled(['enabled' => TRUE]), 'Thumbnail reports enabled.');
    $this->assertFalse($thumbnail_disabled->isEnabled(['enabled' => FALSE]), 'Thumbnail reports disabled.');
  }

  /**
   * Test general plugin is always enabled.
   */
  public function testGeneralPluginAlwaysEnabled(): void {
    $general = $this->pluginManager->createInstance('general');

    $this->assertTrue($general->isEnabled([]), 'General plugin is always enabled.');
  }

  /**
   * Test plugin manager creates instances correctly.
   */
  public function testPluginManagerCreatesInstances(): void {
    $general = $this->pluginManager->createInstance('general');
    $thumbnail = $this->pluginManager->createInstance('thumbnail');

    $this->assertNotNull($general, 'General plugin instantiated.');
    $this->assertNotNull($thumbnail, 'Thumbnail plugin instantiated.');
  }

  /**
   * Test plugins return JS settings.
   */
  public function testPluginsReturnJsSettings(): void {
    $general = $this->pluginManager->createInstance('general');
    $js_settings = $general->buildJsSettings($general->defaultSettings());

    $this->assertArrayHasKey('licenseKey', $js_settings, 'General includes licenseKey.');
    $this->assertArrayHasKey('loop', $js_settings, 'General includes loop.');
    $this->assertArrayHasKey('speed', $js_settings, 'General includes speed.');
  }

}
