<?php

namespace Drupal\lightgallery_formatter\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\lightgallery_formatter\Entity\LightgalleryProfile;
use Drupal\Core\Url;
use Drupal\Core\Link;

/**
 * Controller for listing LightGallery profile entities.
 */
class LightgalleryProfileController extends ControllerBase {

  /**
   * List all LightGallery profile entities.
   *
   * @return array
   *   A render array containing the profiles table.
   */
  public function listProfiles() {
    $build = [];

    $build['description'] = [
      '#markup' => $this->t('Manage reusable gallery configurations.'),
      '#prefix' => '<p>',
      '#suffix' => '</p>',
    ];

    $build['add_link'] = [
      '#type' => 'link',
      '#title' => $this->t('Add LightGallery profile'),
      '#url' => Url::fromRoute('entity.lightgallery_profile.add_form'),
      '#attributes' => [
        'class' => ['button', 'button--primary', 'button--action'],
      ],
      '#prefix' => '<p>',
      '#suffix' => '</p>',
    ];

    $headers = [
      $this->t('Label'),
      $this->t('Machine name'),
      $this->t('Enabled'),
      $this->t('Operations'),
    ];

    $rows = [];
    $profiles = LightgalleryProfile::loadMultiple();

    foreach ($profiles as $profile) {
      $rows[] = [
        'data' => [
          Link::fromTextAndUrl($profile->label(), Url::fromRoute('entity.lightgallery_profile.edit_form', ['lightgallery_profile' => $profile->id()])),
          $profile->id(),
          $profile->status() ? $this->t('Yes') : $this->t('No'),
          [
            'data' => [
              '#type' => 'operations',
              '#links' => [
                'edit' => [
                  'title' => $this->t('Edit'),
                  'url' => Url::fromRoute('entity.lightgallery_profile.edit_form', ['lightgallery_profile' => $profile->id()]),
                ],
                'delete' => [
                  'title' => $this->t('Delete'),
                  'url' => Url::fromRoute('entity.lightgallery_profile.delete_form', ['lightgallery_profile' => $profile->id()]),
                ],
              ],
            ],
          ],
        ],
      ];
    }

    $build['profiles_table'] = [
      '#type' => 'table',
      '#header' => $headers,
      '#rows' => $rows,
      '#empty' => $this->t('No LightGallery profiles available. <a href=":add">Add one</a>.', [
        ':add' => Url::fromRoute('entity.lightgallery_profile.add_form')->toString(),
      ]),
    ];

    return $build;
  }

}
