<?php

namespace Drupal\lightgallery_formatter\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the LightGallery profile configuration entity.
 *
 * @ConfigEntityType(
 *   id = "lightgallery_profile",
 *   label = @Translation("LightGallery profile"),
 *   handlers = {
 *     "list_builder" = "Drupal\lightgallery_formatter\Controller\LightgalleryProfileController",
 *     "form" = {
 *       "add" = "Drupal\lightgallery_formatter\Form\LightgalleryProfileForm",
 *       "edit" = "Drupal\lightgallery_formatter\Form\LightgalleryProfileForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     }
 *   },
 *   config_prefix = "profile",
 *   admin_permission = "administer lightgallery_formatter",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "status" = "status"
 *   },
 *   links = {
 *     "collection" = "/admin/structure/lightgallery-profiles",
 *     "add-form" = "/admin/structure/lightgallery-profiles/add",
 *     "edit-form" = "/admin/structure/lightgallery-profiles/{lightgallery_profile}",
 *     "delete-form" = "/admin/structure/lightgallery-profiles/{lightgallery_profile}/delete"
 *   },
 *   config_export = {
 *     "id" = "id",
 *     "label" = "label",
 *     "status" = "status",
 *     "plugin_settings" = "plugin_settings"
 *   }
 * )
 */
class LightgalleryProfile extends ConfigEntityBase implements LightgalleryProfileInterface {

  /**
   * The machine name of the profile.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable name of the profile.
   *
   * @var string
   */
  protected $label;

  /**
   * Whether the profile is enabled.
   *
   * @var bool
   */
  protected $status = TRUE;

  /**
   * Plugin configurations.
   *
   * @var array
   */
  protected $plugin_settings = [];

  /**
   * {@inheritdoc}
   */
  public function getStatus(): bool {
    return (bool) $this->status;
  }

  /**
   * {@inheritdoc}
   */
  public function getPluginSettings(string $plugin_id): array {
    return $this->plugin_settings[$plugin_id] ?? [];
  }

  /**
   * {@inheritdoc}
   */
  public function setPluginSettings(string $plugin_id, array $settings): LightgalleryProfileInterface {
    $this->plugin_settings[$plugin_id] = $settings;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function getAllPluginSettings(): array {
    return $this->plugin_settings;
  }

}
