<?php

namespace Drupal\lightgallery_formatter\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Interface for LightgalleryProfile entities.
 */
interface LightgalleryProfileInterface extends ConfigEntityInterface {

  /**
   * Gets the status.
   *
   * @return bool
   *   TRUE if enabled, FALSE otherwise.
   */
  public function getStatus(): bool;

  /**
   * Get plugin settings.
   *
   * @param string $plugin_id
   *   The plugin ID.
   *
   * @return array
   *   The plugin settings.
   */
  public function getPluginSettings(string $plugin_id): array;

  /**
   * Set plugin settings.
   *
   * @param string $plugin_id
   *   The plugin ID.
   * @param array $settings
   *   The plugin settings.
   *
   * @return $this
   */
  public function setPluginSettings(string $plugin_id, array $settings): self;

  /**
   * Get all plugin settings.
   *
   * @return array
   *   All plugin settings keyed by plugin ID.
   */
  public function getAllPluginSettings(): array;

}
