<?php

declare(strict_types=1);

namespace Drupal\lightgallery_formatter;

/**
 * Provides information about the bundled LightGallery library.
 *
 * This class centralizes library version information to ensure
 * consistency across the module (status reports, admin forms, etc.).
 */
final class LightgalleryLibraryInfo {

  /**
   * The version of the bundled LightGallery library.
   */
  public const VERSION = '2.9.0';

  /**
   * The official LightGallery website URL.
   */
  public const WEBSITE_URL = 'https://www.lightgalleryjs.com';

  /**
   * The LightGallery GitHub repository URL.
   */
  public const GITHUB_URL = 'https://github.com/sachinchoolur/lightGallery';

  /**
   * The LightGallery license page URL.
   */
  public const LICENSE_URL = 'https://www.lightgalleryjs.com/license/';

  /**
   * The version of React bundled with the module.
   */
  public const REACT_VERSION = '18.2.0';

  /**
   * Gets the full library description with version.
   *
   * @return string
   *   The library description.
   */
  public static function getDescription(): string {
    return sprintf(
      'LightGallery %s (React %s)',
      self::VERSION,
      self::REACT_VERSION
    );
  }

  /**
   * Gets library information as an array.
   *
   * @return array
   *   Array with library information.
   */
  public static function getInfo(): array {
    return [
      'lightgallery_version' => self::VERSION,
      'react_version' => self::REACT_VERSION,
      'website_url' => self::WEBSITE_URL,
      'github_url' => self::GITHUB_URL,
      'license_url' => self::LICENSE_URL,
    ];
  }

}
