<?php

namespace Drupal\Tests\lightgallery_formatter\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests plugin form rendering in LightGallery profile form.
 *
 * @group lightgallery_formatter
 */
class LightgalleryProfileFormPluginRenderTest extends BrowserTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['lightgallery_formatter'];

  /**
   * The default theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with admin permissions.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser([
      'administer lightgallery_formatter',
      'administer site configuration',
    ]);
  }

  /**
   * Test that profile add form loads without errors.
   */
  public function testProfileAddFormLoads(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Add LightGallery profile');
  }

  /**
   * Test that profile edit form loads without errors.
   */
  public function testProfileEditFormLoads(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/default');

    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Edit');
  }

  /**
   * Test that general settings section renders.
   */
  public function testGeneralSettingsSectionRenders(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    // Check for general settings text labels.
    $this->assertSession()->pageTextContains('General Settings');
    $this->assertSession()->pageTextContains('Enable looping');
    $this->assertSession()->pageTextContains('Transition speed');
  }

  /**
   * Test that thumbnail settings section renders.
   */
  public function testThumbnailSettingsSectionRenders(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    // Check for thumbnail settings text.
    $this->assertSession()->pageTextContains('Thumbnail Navigation');
    $this->assertSession()->pageTextContains('Enable thumbnail plugin');
  }

  /**
   * Test plugin sections have correct form elements.
   */
  public function testPluginSectionsHaveCorrectElements(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    // Check for various settings labels that should be present.
    $this->assertSession()->pageTextContains('Close with Esc key');
    $this->assertSession()->pageTextContains('Keyboard navigation');
    $this->assertSession()->pageTextContains('Show close icon');
    $this->assertSession()->pageTextContains('Mouse wheel navigation');
  }

  /**
   * Test label and ID fields exist.
   */
  public function testBasicFieldsExist(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    $this->assertSession()->fieldExists('label');
    $this->assertSession()->fieldExists('id');
    $this->assertSession()->fieldExists('status');
  }

  /**
   * Test form has submit button.
   */
  public function testFormHasSubmitButton(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    $this->assertSession()->buttonExists('Save');
  }

  /**
   * Test that default values are populated correctly.
   */
  public function testDefaultValuesPopulated(): void {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/media/lightgallery/add');

    // Just verify the page loads with default values - we check text presence.
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('General Settings');
  }

}
