<?php

namespace Drupal\Tests\lightgallery_formatter\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests library definitions for LightGallery formatter.
 *
 * @group lightgallery_formatter
 */
class LightgalleryLibraryTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['lightgallery_formatter'];

  /**
   * The library discovery service.
   *
   * @var \Drupal\Core\Asset\LibraryDiscoveryInterface
   */
  protected $libraryDiscovery;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->libraryDiscovery = $this->container->get('library.discovery');
  }

  /**
   * Test that the gallery library is defined.
   *
   * The gallery library is a React-based bundle that includes all
   * LightGallery functionality.
   */
  public function testGalleryLibraryExists(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    $this->assertNotEmpty($library, 'Gallery library exists.');
    $this->assertArrayHasKey('js', $library, 'Gallery library has JavaScript.');
    $this->assertArrayHasKey('css', $library, 'Gallery library has CSS.');
    $this->assertArrayHasKey('dependencies', $library, 'Gallery library has dependencies.');
  }

  /**
   * Test gallery library dependencies are correctly defined.
   */
  public function testGalleryLibraryDependencies(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    // Gallery library should depend on core Drupal libraries.
    $this->assertContains('core/drupal', $library['dependencies'], 'Gallery depends on Drupal.');
    $this->assertContains('core/drupalSettings', $library['dependencies'], 'Gallery depends on drupalSettings.');
    $this->assertContains('core/once', $library['dependencies'], 'Gallery depends on once.');
  }

  /**
   * Test gallery library JavaScript files.
   */
  public function testGalleryLibraryJsFiles(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    // Should have JavaScript files.
    $this->assertNotEmpty($library['js'], 'Gallery library has JS files.');
  }

  /**
   * Test gallery library CSS files.
   */
  public function testGalleryLibraryCssFiles(): void {
    $library = $this->libraryDiscovery->getLibraryByName('lightgallery_formatter', 'gallery');

    // Should have CSS files.
    $this->assertNotEmpty($library['css'], 'Gallery library has CSS.');
  }

}
