import { defineConfig } from 'vite';
import react from '@vitejs/plugin-react';
import { resolve } from 'path';

export default defineConfig({
  plugins: [react()],
  build: {
    outDir: 'js/dist',
    emptyOutDir: true,
    lib: {
      entry: resolve(__dirname, 'js/react/bootstrap.jsx'),
      name: 'LightgalleryReact',
      fileName: 'lightgallery-react',
      formats: ['es'],
    },
    rollupOptions: {
      output: {
        // Ensure single file output with all dependencies bundled.
        inlineDynamicImports: true,
      },
    },
    // Minimize JS with esbuild (fastest, good compression).
    minify: 'esbuild',
    // CSS minification options.
    cssMinify: true,
    // No sourcemaps for production.
    sourcemap: false,
    // Target modern browsers for smaller output.
    target: 'es2020',
  },
  // Optimize CSS processing.
  css: {
    devSourcemap: false,
  },
  // Esbuild options for better minification.
  esbuild: {
    // Only drop debugger statements, keep console for license warnings.
    drop: ['debugger'],
    minifyIdentifiers: true,
    minifySyntax: true,
    minifyWhitespace: true,
  },
  define: {
    'process.env.NODE_ENV': JSON.stringify('production'),
  },
});
