<?php

namespace Drupal\line_add_friend\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure LINE Add Friend settings.
 */
class LineAddFriendSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['line_add_friend.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'line_add_friend_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('line_add_friend.settings');

    $form['line_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('LINE ID'),
      '#description' => $this->t('Enter your LINE ID (e.g., lineteamjp or @lineteamjp).'),
      '#default_value' => $config->get('line_id'),
      '#required' => TRUE,
    ];

    $form['show_count'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Show number of friends'),
      '#description' => $this->t('Display the number of friends on the button.'),
      '#default_value' => $config->get('show_count') ?? TRUE,
    ];

    $form['show_home'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable home button'),
      '#description' => $this->t('Enable the home button feature.'),
      '#default_value' => $config->get('show_home') ?? TRUE,
    ];

    $form['language'] = [
      '#type' => 'select',
      '#title' => $this->t('Language'),
      '#options' => [
        'en' => $this->t('English'),
        'ja' => $this->t('Japanese'),
        'th' => $this->t('Thai'),
        'zh-Hant' => $this->t('Chinese (Traditional)'),
      ],
      '#default_value' => $config->get('language') ?? 'en',
    ];

    $form['button_size'] = [
      '#type' => 'select',
      '#title' => $this->t('Button size'),
      '#options' => [
        'normal' => $this->t('Normal'),
        'M' => $this->t('Medium (M)'),
        'XL' => $this->t('Extra Large (XL)'),
      ],
      '#default_value' => $config->get('button_size') ?? 'normal',
      '#description' => $this->t('Select the size of the LINE Add Friend button.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('line_add_friend.settings')
      ->set('line_id', $form_state->getValue('line_id'))
      ->set('show_count', $form_state->getValue('show_count'))
      ->set('show_home', $form_state->getValue('show_home'))
      ->set('language', $form_state->getValue('language'))
      ->set('button_size', $form_state->getValue('button_size'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
