<?php

namespace Drupal\line_add_friend\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides a 'LINE Add Friend' Block.
 *
 * @Block(
 *   id = "line_add_friend_block",
 *   admin_label = @Translation("LINE Add Friend Button"),
 *   category = @Translation("Social Media"),
 * )
 */
class LineAddFriendBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new LineAddFriendBlock instance.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    protected ConfigFactoryInterface $configFactory,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('config.factory')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $config = $this->configFactory->get('line_add_friend.settings');
    $line_id = $config->get('line_id');

    if (empty($line_id)) {
      return [];
    }

    return [
      '#theme' => 'line_add_friend_block',
      '#line_id' => $line_id,
      '#show_count' => $config->get('show_count') ?? TRUE,
      '#show_home' => $config->get('show_home') ?? TRUE,
      '#language' => $config->get('language') ?? 'en',
      '#button_size' => $config->get('button_size') ?? 'normal',
      '#attached' => [
        'library' => [
          'line_add_friend/line_add_friend',
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheMaxAge() {
    return 0;
  }

}
