<?php

namespace Drupal\Tests\lingotek\Unit\Form;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Routing\UrlGeneratorInterface;
use Drupal\Core\Utility\LinkGeneratorInterface;
use Drupal\lingotek\Form\LingotekSettingsTabAccountForm;
use Drupal\lingotek\LingotekFilterManagerInterface;
use Drupal\lingotek\LingotekInterface;
use Drupal\Tests\UnitTestCase;

/**
 * @coversDefaultClass \Drupal\lingotek\Form\LingotekSettingsTabAccountForm
 * @group lingotek
 * @preserveGlobalState disabled
 */
class LingotekSettingsTabAccountFormTest extends UnitTestCase {

  /**
   * The Lingotek service
   *
   * @var \Drupal\lingotek\LingotekInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $lingotek;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $configFactory;

  /**
   * The Lingotek Filter manager.
   *
   * @var \Drupal\lingotek\LingotekFilterManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $lingotekFilterManager;

  /**
   * The url generator.
   *
   * @var \Drupal\Core\Routing\UrlGeneratorInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $urlGenerator;

  /**
   * The link generator.
   *
   * @var \Drupal\Core\Utility\LinkGeneratorInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $linkGenerator;

  /**
   * @var \Drupal\lingotek\Form\LingotekSettingsTabAccountForm
   */
  protected $form;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->lingotek = $this->createMock(LingotekInterface::class);
    $this->configFactory = $this->createMock(ConfigFactoryInterface::class);
    $this->lingotekFilterManager = $this->createMock(LingotekFilterManagerInterface::class);
    $this->urlGenerator = $this->createMock(UrlGeneratorInterface::class);
    $this->linkGenerator = $this->createMock(LinkGeneratorInterface::class);
    $messenger = $this->createMock(MessengerInterface::class);

    $this->form = new LingotekSettingsTabAccountForm(
      $this->lingotek,
      $this->configFactory,
      $this->lingotekFilterManager,
      $this->urlGenerator,
      $this->linkGenerator
    );
    $this->form->setStringTranslation($this->getStringTranslationStub());
    $this->form->setMessenger($messenger);
  }

  /**
   * @covers ::getFormId
   */
  public function testGetFormId() {
    $form_id = $this->form->getFormID();
    $this->assertSame('lingotek.settings_tab_account_form', $form_id);
  }

  /**
   * @covers ::buildForm
   */
  public function testBuildForm() {
    $config = $this->createMock(Config::class);
    $accountConfig = $this->createMock(Config::class);
    $accountConfig->expects($this->any())
      ->method('get')
      ->willReturnMap([
        ['login_id', 'test@example.com'],
        ['access_token', 'ef4b4d69-5be2-4513-b4f1-7e0f6f9511a0'],
      ]);
    $this->configFactory->expects($this->exactly(1))
      ->method('get')
      ->with('lingotek.account')
      ->willReturn($accountConfig);

    $this->lingotekFilterManager->expects($this->once())
      ->method('getLocallyAvailableFilters')
      ->willReturn([
        'filter 1' => 'filter-uuid-1',
      ]);

    $build = [];
    $form_state = $this->createMock(FormStateInterface::class);
    $build = $this->form->buildForm($build, $form_state);
    $this->assertSame('************************************', $build['account']['account_table']['token_row'][1]['#markup']);
  }

  /**
   * @covers ::disconnect
   */
  public function testDisconnect() {
    $build = [];
    $form_state = $this->createMock(FormStateInterface::class);
    $form_state->expects($this->once())
      ->method('setRedirect')
      ->with('lingotek.account_disconnect');
    $build = $this->form->disconnect($build, $form_state);
  }

}
