(function ($, once, Drupal) {
  Drupal.behaviors.lingotekLocalesTableFilterByText = {
    attach: function attach() {
      // var $input = $('input.locales-filter-text').once('locales-filter-text');
      let $input = $(once('locales-filter-text','input.locales-filter-text'));
      let $table = $($input.attr('data-table'));
      let $rows;

      function filterLocalesList(e) {
        let query = $(e.target).val().toLowerCase();

        function showViewRow(index, row) {
          let $row = $(row);
          let $sources = $row.find('*');
          let textMatch = $sources.text().toLowerCase().indexOf(query) !== -1;
          $row.closest('tr').toggle(textMatch);
        }

        if (query.length >= 2) {
          $rows.each(showViewRow);
        } else {
          $rows.show();
        }
      }

      if ($table.length) {
        $rows = $table.find('tbody tr');
        $input.on('keyup', filterLocalesList);
      }
    }
  };
})(jQuery, once, Drupal);
