<?php

namespace Drupal\lingotek;

use Drupal\Core\Entity\EntityTypeManagerInterface;

class LingotekJobManagementService {

  protected EntityTypeManagerInterface $entityTypeManager;

  public function __construct() {
    $this->entityTypeManager = \Drupal::service('entity_type.manager');
  }

  public function getAllContentJobs(array &$jobs) {
    $entity_query = \Drupal::entityQuery('lingotek_content_metadata');
    $entity_query->accessCheck(FALSE);
    $entity_query->exists('job_id');
    $ids = $entity_query->execute();

    /** @var \Drupal\lingotek\Entity\LingotekContentMetadata[] $metadatas */
    $metadatas = $this->entityTypeManager->getStorage('lingotek_content_metadata')
      ->loadMultiple($ids);
    foreach ($metadatas as $metadata) {
      $job_id = $metadata->getJobId();
      if (!empty($job_id)) {
        if (!isset($jobs[$job_id])) {
          $jobs[$job_id] = [
            'id' => $job_id,
            'content' => 0,
            'config' => 0,
          ];
        }
        ++$jobs[$job_id]['content'];
      }
    }
    return $jobs;
  }

  public function getAllConfigJobs(array &$jobs) {
    $entity_query = \Drupal::entityQuery('lingotek_config_metadata');
    $entity_query->accessCheck(FALSE);
    $entity_query->exists('job_id');
    $ids = $entity_query->execute();

    /** @var \Drupal\lingotek\Entity\LingotekContentMetadata[] $metadatas */
    $metadatas = $this->entityTypeManager->getStorage('lingotek_config_metadata')
      ->loadMultiple($ids);
    foreach ($metadatas as $metadata) {
      $job_id = $metadata->getJobId();
      if (!empty($job_id)) {
        if (!isset($jobs[$job_id])) {
          $jobs[$job_id] = [
            'id' => $job_id,
            'content' => 0,
            'config' => 0,
          ];
        }
        ++$jobs[$job_id]['config'];
      }
    }
    return $jobs;
  }

}
