# Link an ORCID

Confidently save a user's ORCID to a configured field, authenticated by the ORCID API.

## Features

- Choose a plain text field on the User entity to store an authenticated ORCID iD.
- Use the Key module to store the ORCID client secret securely.
- Users can link/unlink their own ORCID from their profile using a secure OAuth flow.
- The configured ORCID field is disabled and can only be set via the "Link ORCID" button.

## Post-Installation

1. Create a plain text field on the User entity to hold the ORCID iD.
2. Configure at: /admin/config/people/link-orcid (Configuration > People > Link an ORCID settings)

   - Enter your ORCID API Client ID.
   - Select the Key that stores your ORCID Client Secret.
   - Choose the user field to store the ORCID iD.
   - Toggle Sandbox for testing.

3. Grant the "link own orcid" permission to appropriate roles. The configuration form includes a message and link to help you do this for the Authenticated user role.

## Usage

- On your own user edit form, click the "Link ORCID" button next to the configured field. The field is disabled for manual editing and will be set automatically after linking.
- After authorization, you'll be redirected back to your profile edit page with a success or error message.

## Security

- The ORCID client secret is stored in the Key module; this module never stores the raw secret in configuration.

## Testing

- Automated tests are provided in the `tests` directory. To run them, make sure you have `drupal/core-dev` installed and a `phpunit.xml.dist` in your project root. Run:

  ```sh
  ddev exec ./vendor/bin/phpunit --group link_orcid
  ```

  or

  ```sh
  ddev exec ./vendor/bin/phpunit web/modules/custom/link_orcid/tests
  ```
