<?php

namespace Drupal\Tests\link_orcid\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Functional test for Link ORCID module.
 *
 * @group link_orcid
 */
class LinkOrcidTest extends BrowserTestBase {

  /**
   * Test unlinking ORCID from user profile.
   */
  public function testUnlinkOrcid() {
    $user = $this->drupalCreateUser(['link own orcid']);
    $this->drupalLogin($user);

    // Set a fake ORCID value for the user.
    $field_name = \Drupal::config('link_orcid.settings')->get('user_field');
    $user->set($field_name, '0000-0002-1825-0097');
    $user->save();

    // Go to profile edit page and confirm Unlink button is present.
    $this->drupalGet('user/' . $user->id() . '/edit');
    $this->assertSession()->pageTextContains('Unlink ORCID');

    // Click the Unlink button (simulate request).
    $this->drupalGet('/link-orcid/unlink');
    $this->assertSession()->pageTextContains('Your ORCID has been unlinked.');

    // Reload user and confirm field is empty.
    $user = \Drupal::entityTypeManager()->getStorage('user')->load($user->id());
    $this->assertTrue(empty($user->get($field_name)->value));
  }

  /**
   * Use the Stark theme for functional tests.
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['user', 'field', 'key', 'link_orcid'];

  /**
   * Test ORCID link button appears for authenticated users.
   */
  public function testOrcidButtonAppears() {
    // Create a user with permission.
    $user = $this->drupalCreateUser(['link own orcid']);
    $this->drupalLogin($user);

    // Go to profile edit page.
    $this->drupalGet('user/' . $user->id() . '/edit');
    $this->assertSession()->pageTextContains('Link ORCID');
  }

  /**
   * Test config form displays permission info message.
   */
  public function testConfigFormPermissionMessage() {
    $admin = $this->drupalCreateUser(['administer link orcid']);
    $this->drupalLogin($admin);
    $this->drupalGet('admin/config/people/link-orcid');
    $this->assertSession()->pageTextContains('grant the link own orcid permission');
  }

}
