<?php

namespace Drupal\Tests\link_orcid\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\link_orcid\OrcidClient;

/**
 * Kernel test for OrcidClient logic.
 *
 * @group link_orcid
 */
class OrcidClientTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['system', 'user', 'field', 'key', 'link_orcid'];

  /**
   * Test config returns correct values.
   */
  public function testConfigValues() {
    // Set config values for testing.
    $this->config('link_orcid.settings')
      ->set('client_id', 'test_client_id')
      ->set('user_field', 'field_orcid')
      ->save();

    $client = $this->container->get('link_orcid.client');
    $this->assertInstanceOf(OrcidClient::class, $client);
    $config = $this->config('link_orcid.settings');
    $this->assertNotEmpty($config->get('client_id'));
    $this->assertNotEmpty($config->get('user_field'));
  }

}
