(function (Drupal, drupalSettings) {
  Drupal.behaviors.linkParamPropagator = {
    attach: function (context, settings) {
      const cfg = (settings.linkParamPropagator && settings.linkParamPropagator.rules) || [];
      if (!Array.isArray(cfg) || cfg.length === 0) return;
      if (!window.location.search) return;

      // Current page params once.
      const pageParams = new URLSearchParams(window.location.search);
      if ([...pageParams.keys()].length === 0) return;

      cfg.forEach((rule, idx) => {
        const trackingParams = Array.isArray(rule.trackingParams) ? rule.trackingParams : [];
        const targetSelector = typeof rule.targetSelector === 'string' && rule.targetSelector.trim()
          ? rule.targetSelector.trim()
          : 'body';

        if (trackingParams.length === 0) return;

        // Build filtered params for this rule only once.
        const filtered = new URLSearchParams();
        trackingParams.forEach((key) => {
          if (pageParams.has(key)) {
            filtered.set(key, pageParams.get(key));
          }
        });
        if (!filtered.toString()) return;

        // Process containers once per attach.
        const containers = (typeof once === 'function')
          ? once(`lpp-container-${idx}`, targetSelector, context)
          : context.querySelectorAll(targetSelector);

        containers.forEach((container) => {
          // Process links once per container.
          const links = (typeof once === 'function')
            ? once('lpp-link', 'a[href]', container)
            : container.querySelectorAll('a[href]');

          links.forEach((link) => {
            const href = link.getAttribute('href');
            if (!href || href.startsWith('#') || href.startsWith('mailto:') || href.startsWith('tel:')) return;

            try {
              const url = new URL(href, window.location.origin);

              trackingParams.forEach((key) => {
                if (!url.searchParams.has(key) && filtered.has(key)) {
                  url.searchParams.append(key, filtered.get(key));
                }
              });

              link.setAttribute('href', url.toString());
            } catch (e) {
              // Ignore invalid/relative URLs that can't be parsed by URL()
            }
          });
        });
      });
    },
  };
})(Drupal, drupalSettings);
