<?php
namespace Drupal\linkchecker_request_tag\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\linkchecker\Event\LinkcheckerEvents;

/**
 * Class EntityTypeSubscriber.
 *
 * @package Drupal\linkchecker_request_tag\EventSubscriber
 */
class LinkCheckerEventsSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   *
   *  @return array 
   *    The event names to listen for, and the methods that should
   *    be executed when detected.
   */
  public static function getSubscribedEvents() {
    return [
      LinkcheckerEvents::BUILD_HEADER => 'onRequestHeadersAlter'
    ];
  }

  /**
   * Alters the outgoing LinkChecker request headers
   * 
   * @param $event 
   *   The event object.
   * 
   * @return void
   */
  public function onRequestHeadersAlter($event) {
    $headers = $event->getHeaders();
    $headers['X-origin'] = 'DrupalLinkChecker';
    $event->setHeaders($headers);
  }
}