<?php

namespace Drupal\links_action_ui;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Provides a listing of Local Action entities.
 */
class LocalActionListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Button Text');
    $header['route_name'] = $this->t('Target Route');
    $header['appears_on'] = $this->t('Appears On');
    $header['weight'] = $this->t('Weight');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\links_action_ui\Entity\LocalAction $entity */
    $row['label'] = $entity->label();
    $row['url'] = $entity->getUrl();
    $appears_on = $entity->getAppearsOnUrls();
    $row['appears_on'] = implode(',', $appears_on);
    $row['weight'] = $entity->getWeight();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getOperations(EntityInterface $entity) {
    $operations = parent::getOperations($entity);

    $operations['edit'] = [
      'title' => $this->t('Edit'),
      'url' => $entity->toUrl('edit-form'),
      'weight' => 10,
    ];
    $operations['delete'] = [
      'title' => $this->t('Delete'),
      'url' => $entity->toUrl('delete-form'),
      'weight' => 100,
    ];
    
    return $operations;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    // add button.
    $build['header_actions'] = [
      '#type' => 'link',
      '#title' => $this->t('Add Local Action'),
      '#url' => Url::fromRoute('entity.local_action.add_form'),
      '#attributes' => [
        'class' => ['button', 'button--primary'],
      ],
      '#weight' => -10,
    ];
    $build['table']['#empty'] = $this->t('No local actions available. <a href=":link">Add a local action</a>.', [
      ':link' => Url::fromRoute('entity.local_action.add_form')->toString(),
    ]);
    return $build;
  }

}
