<?php

namespace Drupal\links_action_ui\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\links_action_ui\Form\LocalActionForm;
use Drupal\Core\Config\Entity\ConfigEntityStorage;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\links_action_ui\LocalActionListBuilder;
use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the Local Action entity class.
 */
#[ConfigEntityType(
  id: 'local_action',
  label: new TranslatableMarkup('Local Action'),
  label_collection: new TranslatableMarkup('Local Actions'),
  label_singular: new TranslatableMarkup('local action'),
  label_plural: new TranslatableMarkup('local actions'),
  config_prefix: 'local_action',
  static_cache: TRUE,
  entity_keys: [
    'id' => 'id',
    'label' => 'title',
    'weight' => 'weight',
  ],
  handlers: [
    'storage' => ConfigEntityStorage::class,
    'access' => EntityAccessControlHandler::class,
    'list_builder' => LocalActionListBuilder::class,
    'form' => [
      'default' => LocalActionForm::class,
      'add' => LocalActionForm::class,
      'delete' => \Drupal\Core\Entity\EntityDeleteForm::class,
    ],
    'route_provider' => [
      'html' => \Drupal\Core\Entity\Routing\AdminHtmlRouteProvider::class,
    ],
  ],
  links: [
    'canonical' => '/admin/config/system/local-actions/{local_action}',
    'add-form' => '/admin/config/system/local-actions/add',
    'edit-form' => '/admin/config/system/local-actions/{local_action}/edit',
    'delete-form' => '/admin/config/system/local-actions/{local_action}/delete',
    'collection' => '/admin/config/system/local-actions',
  ],
  admin_permission: 'administer site configuration',
  label_count: [
    'singular' => '@count local action',
    'plural' => '@count local actions',
  ],
  config_export: [
    'id',
    'title',
    'route_name',
    'route_parameters',
    'weight',
    'source_id',
    'appears_on'
  ],
)]
class LocalAction extends ConfigEntityBase implements ConfigEntityInterface {

  /**
   * The Local Action ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The Local Action title (button text).
   *
   * @var string
   */
  protected $title;

  /**
   * The target route name.
   *
   * @var string
   */
  protected $route_name;

  /**
   * route parameters.
   * @var 
   */
  protected $route_parameters = [];

  /**
   * Array of routes where this action appears.
   *
   * @var array
   */
  protected $appears_on = [];

  protected $source_id = '';

  /**
   * The weight for ordering.
   *
   * @var int
   */
  protected $weight = 0;

  public function getName() {
    return $this->title;
  }

  public function getTitle() {
    return $this->title;
  }

  /**
   * Get the target route name.
   */
  public function getRouteName() {
    return $this->route_name;
  }

  /**
   * get source id.
   */
  public function getSourceID() {
    return $this->source_id;
  }

  /**
   * set source id.
   */
  public function setSrouceID($source_id) {
    $this->source_id = $source_id;
  }

  public function getRouteParameters() {
    return $this->route_parameters;
  }

  /**
   * Get the routes where this action appears.
   */
  public function getAppearsOn() {
    return $this->appears_on;
  }

  /**
   * Get the weight.
   */
  public function getWeight() {
    return $this->weight;
  }
}
