<?php

namespace Drupal\links_action_ui\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\Config\Entity\ConfigEntityStorageInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Derivative class for dynamic local actions.
 */
class LinksLocalAction extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * The local action storage.
   *
   * @var \Drupal\Core\Config\Entity\ConfigEntityStorageInterface
   */
  protected $storage;

  /**
   * Constructs a new DynamicLocalActionDerivative.
   */
  public function __construct(ConfigEntityStorageInterface $storage) {
    $this->storage = $storage;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('entity_type.manager')->getStorage('local_action')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $links = [];

    return $links;
    // define local action entity.
    $local_actions = $this->storage->loadMultiple();
    foreach ($local_actions as $local_action) {
      $derivative_id = 'dynamic_local_action_' . $local_action->id();
      $links[$derivative_id] = [
        'title' => $this->t($local_action->getTitle()),
        'route_name' => $local_action->getRouteName(),
        'route_parameters' => $local_action->getRouteParameters(),
        'weight' => $local_action->getWeight(),
        'appears_on' => $local_action->getAppearsOn()
      ] + $base_plugin_definition;
    }

    return $links;
  }

}
