<?php

namespace Drupal\tmgmt_contentapi\FormHelper;

use Drupal\Core\Form\FormStateInterface;

/**
 * Helper for building the code analysis settings form section.
 */
class ContentApiAnalysisCodeFormHelper {

  /**
   * Builds the code analysis settings form section.
   *
   * @param array $form
   *   The form array to add to.
   * @param array $form_state
   *   The form state array.
   * @param array $codeanalysissettings
   *   The current code analysis settings.
   *
   * @return array
   *   The code analysis settings form section.
   */
  public static function buildFormSection(array $form, $form_state, array $codeanalysissettings) {

    $form['code-analysis-settings'] = [
      '#type' => 'details',
      '#title' => t('Analysis Code Settings'),
      '#description' => t('Specify the settings for Analysis Codes.'),
      '#open' => TRUE,
    ];
    $form['code-analysis-settings']['freeway_auth_url'] = [
      '#type' => 'textfield',
      '#title' => t('Freeway Auth URL'),
      '#description' => t('Enter the Freeway Auth URL.<br/> Default value: https://fwapi.lionbridge.com/Obvibundles/freewayauth.asmx <br> Staging value: https://fwapi.staging.lionbridge.com/Obvibundles/freewayauth.asmx'),
      '#default_value' => $codeanalysissettings['freeway_auth_url'],
      
    ];
    $form['code-analysis-settings']['freeway_service_url'] = [
      '#type' => 'textfield',
      '#title' => t('Freeway Service URL'),
      '#description' => t('Enter the Freeway Service URL.<br/> Default value: https://fwapi.lionbridge.com/Obvibundles/Service.asmx <br> Staging value: https://fwapi.staging.lionbridge.com/Obvibundles/Service.asmx'),
      '#default_value' => $codeanalysissettings['freeway_service_url'],
    ];
    $form['code-analysis-settings']['analysis_code_username'] = [
      '#type' => 'textfield',
      '#title' => t('Login Name'),
      '#description' => t('Enter the Login Name.'),
      '#default_value' => $codeanalysissettings['analysis_code_username'],
    ];
    $form['code-analysis-settings']['analysis_code_password'] = [
      '#type' => 'textfield',
      '#title' => t('Login Password'),
      '#description' => t('Enter the Login Password.'),
      '#default_value' => $codeanalysissettings['analysis_code_password'],
    ];
    // Arrange the AJAX message and test_connection button in a row, aligned with the password textbox (no flex, use #type 'item' for message and #process for alignment).
    $form['code-analysis-settings']['test_connection_row'] = [
      '#type' => 'container',
    ];
    $form['code-analysis-settings']['test_connection_row']['freeway_connection_test_result'] = [
      '#type' => 'item',
      '#markup' => '<div id="freeway-connection-test-result" class="connection-error"></div>',
    ];
    $form['code-analysis-settings']['test_connection_row']['test_connection'] = [
      '#type' => 'submit',
      '#value' => t('Test'),
      '#ajax' => [
        'callback' => 'tmgmt_contentapi_ajax_test_freeway_connection',
        'wrapper' => 'freeway-connection-test-result',
      ],
    ];
    // Add three checkboxes in a single line under a bold label "Freeway Analysis Code".
    $form['code-analysis-settings']['code_group'] = [
      '#type' => 'container',
      '#markup' => '<div><strong>' . t('Analysis Codes visibility') . '</strong></div>',
      '#attributes' => [
        'style' => 'display: flex; gap: 2em; align-items: center; margin-top: 0.5em;',
        'id' => 'code-group-wrapper',
      ],
    ];
    $level_title1 = 'Require value 1';
    $level_title2 = 'Require value 2';
    $level_title3 = 'Require value 3';
    // Add the checkboxes for the analysis codes.
    $form['code-analysis-settings']['code_group']['level_1'] = [
      '#type' => 'checkbox',
      '#title' => t($level_title1),
      '#attributes' => ['id' => 'level1'],
      '#default_value' => $codeanalysissettings['code_group']['level_1'] ?? 0,
    ];
    $form['code-analysis-settings']['code_group']['level_2'] = [
      '#type' => 'checkbox',
      '#title' => t($level_title2),
      '#attributes' => ['id' => 'level2'],
      '#default_value' => $codeanalysissettings['code_group']['level_2'] ?? 0,
    ];
    $form['code-analysis-settings']['code_group']['level_3'] = [
      '#type' => 'checkbox',
      '#title' => t($level_title3),
      '#attributes' => ['id' => 'level3'],
      '#default_value' => $codeanalysissettings['code_group']['level_3'] ?? 0,
    ];
    return $form;
  }

}
